<?php

use Utopia\Config\Config;
use Utopia\Database\Database;

$providers = Config::getParam('providers', []);
$auth = Config::getParam('auth', []);

/**
 * $collection => id of the parent collection where this will be inserted
 * $id => id of this collection
 * name => name of this collection
 * project => whether or not this collection should be created per project
 * attributes => list of attributes
 * indexes => list of indexes
 */

$collections = [
    'collections' => [
        '$collection' => Database::METADATA,
        '$id' => 'collections',
        'name' => 'Collections',
        'attributes' => [
            [
                '$id' => 'name',
                'type' => Database::VAR_STRING,
                'size' => 256,
                'required' => true,
                'signed' => true,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'dateCreated',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'dateUpdated',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'enabled',
                'type' => Database::VAR_BOOLEAN,
                'signed' => true,
                'size' => 0,
                'format' => '',
                'filters' => [],
                'required' => true,
                'default' => null,
                'array' => false,
            ],
            [
                '$id' => 'permission',
                'type' => Database::VAR_STRING,
                'size' => 64,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'attributes',
                'type' => Database::VAR_STRING,
                'size' => 1000000,
                'required' => false,
                'signed' => true,
                'array' => false,
                'filters' => ['subQueryAttributes'],
            ],
            [
                '$id' => 'indexes',
                'type' => Database::VAR_STRING,
                'size' => 1000000,
                'required' => false,
                'signed' => true,
                'array' => false,
                'filters' => ['subQueryIndexes'],
            ],
            [
                '$id' => 'search',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => '_fulltext_search',
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
        ],
    ],

    'attributes' => [
        '$collection' => Database::METADATA,
        '$id' => 'attributes',
        'name' => 'Attributes',
        'attributes' => [
            [
                '$id' => 'collectionId',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'key',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'type',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'status',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'size',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'required',
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'default',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['casting'],
            ],
            [
                '$id' => 'signed',
                'type' => Database::VAR_BOOLEAN,
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'array',
                'type' => Database::VAR_BOOLEAN,
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'format',
                'type' => Database::VAR_STRING,
                'size' => 64,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'formatOptions',
                'type' => Database::VAR_STRING,
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => new stdClass,
                'array' => false,
                'filters' => ['json', 'range', 'enum'],
            ],
            [
                '$id' => 'filters',
                'type' => Database::VAR_STRING,
                'size' => 64,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => '_key_collection',
                'type' => Database::INDEX_KEY,
                'attributes' => ['collectionId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'indexes' => [
        '$collection' => Database::METADATA,
        '$id' => 'indexes',
        'name' => 'Indexes',
        'attributes' => [
            [
                '$id' => 'collectionId',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'key',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'type',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'status',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'attributes',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => 'lengths',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => 'orders',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 4,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => '_key_collection',
                'type' => Database::INDEX_KEY,
                'attributes' => ['collectionId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'projects' => [
        '$collection' => Database::METADATA,
        '$id' => 'projects',
        'name' => 'Projects',
        'attributes' => [
            [
                '$id' => 'teamId',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'name',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'description',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'logo',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'url',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'version',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'legalName',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'legalCountry',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'legalState',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'legalCity',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'legalAddress',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'legalTaxId',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'services',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => [],
                'array' => false,
                'filters' => ['json'],
            ],
            [
                '$id' => 'auths',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => [],
                'array' => false,
                'filters' => ['json'],
            ],
            [
                '$id' => 'providers',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => [],
                'array' => false,
                'filters' => ['json', 'encrypt'],
            ],
            [
                '$id' => 'platforms',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['subQueryPlatforms'],
            ],
            [
                '$id' => 'webhooks',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['subQueryWebhooks'],
            ],
            [
                '$id' => 'keys',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['subQueryKeys'],
            ],
            [
                '$id' => 'domains',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['subQueryDomains'],
            ],
            [
                '$id' => 'search',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => '_key_search',
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
        ],
    ],

    'platforms' => [
        '$collection' => Database::METADATA,
        '$id' => 'platforms',
        'name' => 'platforms',
        'attributes' => [
            [
                '$id' => 'projectId',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'type',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'name',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'key',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'store',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'hostname',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'dateCreated',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'dateUpdated',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => '_key_project',
                'type' => Database::INDEX_KEY,
                'attributes' => ['projectId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'domains' => [
        '$collection' => Database::METADATA,
        '$id' => 'domains',
        'name' => 'domains',
        'attributes' => [
            [
                '$id' => 'projectId',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'updated',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'domain',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'tld',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'registerable',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'verification',
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'certificateId',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => '_key_project',
                'type' => Database::INDEX_KEY,
                'attributes' => ['projectId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'keys' => [
        '$collection' => Database::METADATA,
        '$id' => 'keys',
        'name' => 'keys',
        'attributes' => [
            [
                '$id' => 'projectId',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'name',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'scopes',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => 'secret',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 512, // var_dump of \bin2hex(\random_bytes(128)) => string(256) doubling for encryption
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ],
        ],
        'indexes' => [
            [
                '$id' => '_key_project',
                'type' => Database::INDEX_KEY,
                'attributes' => ['projectId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'webhooks' => [
        '$collection' => Database::METADATA,
        '$id' => 'webhooks',
        'name' => 'webhooks',
        'attributes' => [
            [
                '$id' => 'projectId',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'name',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'url',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'httpUser',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'httpPass',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY, // TODO will the length suffice after encryption?
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ],
            [
                '$id' => 'security',
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'events',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => '_key_project',
                'type' => Database::INDEX_KEY,
                'attributes' => ['projectId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'users' => [
        '$collection' => Database::METADATA,
        '$id' => 'users',
        'name' => 'Users',
        'attributes' => [
            [
                '$id' => 'name',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'email',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 320,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'status',
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'password',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'passwordUpdate',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'prefs',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 65535,
                'signed' => true,
                'required' => false,
                'default' => new \stdClass(),
                'array' => false,
                'filters' => ['json'],
            ],
            [
                '$id' => 'registration',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'emailVerification',
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'reset',
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'sessions',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => [],
                'array' => true,
                'filters' => ['json'],
            ],
            [
                '$id' => 'tokens',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => [],
                'array' => true,
                'filters' => ['json'],
            ],
            [
                '$id' => 'memberships',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => [],
                'array' => true,
                'filters' => ['json'],
            ],
            [
                '$id' => 'search',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'deleted',
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => '_key_email',
                'type' => Database::INDEX_UNIQUE,
                'attributes' => ['email'],
                'lengths' => [320],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => '_key_search',
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => '_key_deleted_email',
                'type' => Database::INDEX_KEY,
                'attributes' => ['deleted', 'email'],
                'lengths' => [0, 320],
                'orders' => [Database::ORDER_ASC, Database::ORDER_ASC],
            ],
        ],
    ],

    'sessions' => [
        '$collection' => Database::METADATA,
        '$id' => 'sessions',
        'name' => 'Sessions',
        'attributes' => [
            [
                '$id' => 'userId',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'provider',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'providerUid',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'providerAccessToken',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ],
            [
                '$id' => 'providerAccessTokenExpiry',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'providerRefreshToken',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ],
            [
                '$id' => 'secret',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 512, // https://www.tutorialspoint.com/how-long-is-the-sha256-hash-in-mysql (512 for encryption)
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ],
            [
                '$id' => 'expire',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'userAgent',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'ip',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 45, // https://stackoverflow.com/a/166157/2299554
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'countryCode',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'osCode',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'osName',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'osVersion',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'clientType',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'clientCode',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'clientName',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'clientVersion',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'clientEngine',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'clientEngineVersion',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'deviceName',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'deviceBrand',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'deviceModel',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => '_key_provider_providerUid',
                'type' => Database::INDEX_KEY,
                'attributes' => ['provider', 'providerUid'],
                'lengths' => [100, 100],
                'orders' => [Database::ORDER_ASC, Database::ORDER_ASC],
            ],
        ],
    ],

    'teams' => [
        '$collection' => Database::METADATA,
        '$id' => 'teams',
        'name' => 'Teams',
        'attributes' => [
            [
                '$id' => 'name',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'dateCreated',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'total',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'search',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => '_key_search',
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
        ],
    ],

    'memberships' => [
        '$collection' => Database::METADATA,
        '$id' => 'memberships',
        'name' => 'Memberships',
        'attributes' => [
            [
                '$id' => 'teamId',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'userId',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'roles',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => 'invited',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'joined',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'confirm',
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'secret',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ],
            [
                '$id' => 'search',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => '_key_unique',
                'type' => Database::INDEX_UNIQUE,
                'attributes' => ['teamId', 'userId'],
                'lengths' => [Database::LENGTH_KEY, Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC, Database::ORDER_ASC],
            ],
            [
                '$id' => '_key_team',
                'type' => Database::INDEX_KEY,
                'attributes' => ['teamId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => '_key_user',
                'type' => Database::INDEX_KEY,
                'attributes' => ['userId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => '_key_search',
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
        ],
    ],

    'functions' => [
        '$collection' => Database::METADATA,
        '$id' => 'functions',
        'name' => 'Functions',
        'attributes' => [
            [
                '$id' => 'execute',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => 'name',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'dateCreated',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'dateUpdated',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                'array' => false,
                '$id' => 'status',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'runtime',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'deployment',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'vars',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 8192,
                'signed' => true,
                'required' => false,
                'default' => [],
                'array' => false,
                'filters' => ['json', 'encrypt'],
            ],
            [
                '$id' => 'events',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => 'schedule',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'schedulePrevious',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'scheduleNext',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'timeout',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'search',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => '_key_search',
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [2048],
                'orders' => [Database::ORDER_ASC],
            ]
        ],
    ],

    'deployments' => [
        '$collection' => Database::METADATA,
        '$id' => 'deployments',
        'name' => 'Deployments',
        'attributes' => [
            [
                '$id' => 'dateCreated',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'resourceId',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'resourceType',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'buildId',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                'array' => false,
                '$id' => 'entrypoint',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'path',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'size',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'metadata',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384, // https://tools.ietf.org/html/rfc4288#section-4.2
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['json'],
            ],
            [
                '$id' => 'chunksTotal',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'chunksUploaded',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'search',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'activate',
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => false,
                'array' => false,
                'filters' => [],
            ]
        ],
        'indexes' => [
            [
                '$id' => '_key_resource',
                'type' => Database::INDEX_KEY,
                'attributes' => ['resourceId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => '_key_resource_type',
                'type' => Database::INDEX_KEY,
                'attributes' => ['resourceType'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => '_key_search',
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
        ],
    ],

    'builds' => [
        '$collection' => Database::METADATA,
        '$id' => 'builds',
        'name' => 'Builds',
        'attributes' => [
            [
                '$id' => 'startTime',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'endTime',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'duration',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'deploymentId',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'runtime',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => true,
                'default' => '',
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'status',
                'type' => Database::VAR_STRING, 
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => true,
                'default' => 'processing',
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'outputPath',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => '',
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'stderr',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => '',
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'stdout',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => '',
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'sourceType',
                'type' => Database::VAR_STRING, 
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => true,
                'default' => 'local',
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'source',
                'type' => Database::VAR_STRING, 
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => true,
                'default' => '',
                'array' => false,
                'filters' => [],
            ]
        ],
        'indexes' => [
            [
                '$id' => '_key_deployment',
                'type' => Database::INDEX_KEY,
                'attributes' => ['deploymentId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ]
        ],
    ],

    'executions' => [
        '$collection' => Database::METADATA,
        '$id' => 'executions',
        'name' => 'Executions',
        'attributes' => [
            [
                '$id' => 'dateCreated',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'functionId',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'deploymentId',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                'array' => false,
                '$id' => 'trigger',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'status',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'stdout',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'stderr',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'statusCode',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'time',
                'type' => Database::VAR_FLOAT,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'search',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => '_key_function',
                'type' => Database::INDEX_KEY,
                'attributes' => ['functionId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => '_fulltext_search',
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
        ],
    ],

    'certificates' => [
        '$collection' => Database::METADATA,
        '$id' => 'certificates',
        'name' => 'Certificates',
        'attributes' => [
            [
                '$id' => 'domain',
                'type' => Database::VAR_STRING,
                'format' => '',
                // The maximum total length of a domain name or number is 255 characters.
                // https://datatracker.ietf.org/doc/html/rfc2821#section-4.5.3.1
                // https://datatracker.ietf.org/doc/html/rfc5321#section-4.5.3.1.2
                'size' => 255,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'issueDate',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'renewDate',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'attempts',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'log',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'updated',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => '_key_domain',
                'type' => Database::INDEX_KEY,
                'attributes' => ['domain'],
                'lengths' => [255],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'buckets' => [
        '$collection' => Database::METADATA,
        '$id' => 'buckets',
        'name' => 'Buckets',
        'attributes' => [
            [
                '$id' => 'dateCreated',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'signed' => false,
                'size' => 0,
                'required' => false,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'dateUpdated',
                'type' => Database::VAR_INTEGER,
                'size' => 0,
                'format' => '',
                'signed' => false,
                'required' => false,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'enabled',
                'type' => Database::VAR_BOOLEAN,
                'signed' => true,
                'size' => 0,
                'format' => '',
                'filters' => [],
                'required' => true,
                'array' => false,
            ],
            [
                '$id' => 'name',
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => 128,
                'format' => '',
                'filters' => [],
                'required' => true,
                'array' => false,
            ],
            [
                '$id' => 'permission',
                'type' => Database::VAR_STRING,
                'size' => 64,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'maximumFileSize',
                'type' => Database::VAR_INTEGER,
                'signed' => false,
                'size' => 8,
                'format' => '',
                'filters' => [],
                'required' => true,
                'array' => false,
            ],
            [
                '$id' => 'allowedFileExtensions',
                'type' => Database::VAR_STRING,
                'signed' => true,
                'size' => 64,
                'format' => '',
                'filters' => [],
                'required' => true,
                'array' => true,
            ],
            [
                '$id' => 'encryption',
                'type' => Database::VAR_BOOLEAN,
                'signed' => true,
                'size' => 0,
                'format' => '',
                'filters' => [],
                'required' => true,
                'array' => false,
            ],
            [
                '$id' => 'antivirus',
                'type' => Database::VAR_BOOLEAN,
                'signed' => true,
                'size' => 0,
                'format' => '',
                'filters' => [],
                'required' => true,
                'array' => false,
            ],
            [
                '$id' => 'search',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => '_fulltext_name',
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['name'],
                'lengths' => [1024],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => '_key_search',
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [2048],
                'orders' => [Database::ORDER_ASC],
            ],
        ]
    ],

    'stats' => [
        '$collection' => Database::METADATA,
        '$id' => 'stats',
        'name' => 'Stats',
        'attributes' => [
            [
                '$id' => 'metric',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 255,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'value',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'time',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'period',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 4,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'type',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 1,
                'signed' => false,
                'required' => true,
                'default' => 0, // 0 -> count, 1 -> sum
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => '_key_time',
                'type' => Database::INDEX_KEY,
                'attributes' => ['time'],
                'lengths' => [],
                'orders' => [Database::ORDER_DESC],
            ],
            [
                '$id' => '_key_metric',
                'type' => Database::INDEX_KEY,
                'attributes' => ['metric'],
                'lengths' => [],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => '_key_metric_period',
                'type' => Database::INDEX_KEY,
                'attributes' => ['metric', 'period'],
                'lengths' => [],
                'orders' => [Database::ORDER_DESC],
            ],
        ],
    ],

    'realtime' => [
        '$collection' => Database::METADATA,
        '$id' => 'realtime',
        'name' => 'Realtime Connections',
        'attributes' => [
            [
                '$id' => 'container',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'timestamp',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'value',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [], //TODO: use json filter
            ]
        ],
        'indexes' => [
            [
                '$id' => '_key_timestamp',
                'type' => Database::INDEX_KEY,
                'attributes' => ['timestamp'],
                'lengths' => [],
                'orders' => [Database::ORDER_DESC],
            ],
        ]
    ],
    'files' => [
        '$collection' => 'buckets',
        '$id' => 'files',
        '$name' => 'Files',
        'attributes' => [
            [
                '$id' => 'dateCreated',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                'array' => false,
                '$id' => 'bucketId',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'name',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'path',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'signature',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'mimeType',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 127, // https://tools.ietf.org/html/rfc4288#section-4.2
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'metadata',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384, // https://tools.ietf.org/html/rfc4288#section-4.2
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['json'],
            ],
            [
                '$id' => 'sizeOriginal',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 8,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'sizeActual',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 8,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'algorithm',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 255,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'comment',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'openSSLVersion',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 64,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'openSSLCipher',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 64,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'openSSLTag',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'openSSLIV',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'chunksTotal',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'chunksUploaded',
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'search',
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => '_key_search',
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [2048],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => '_key_bucket',
                'type' => Database::INDEX_KEY,
                'attributes' => ['bucketId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
        ]
    ],
];

return $collections;
