//
//  PBWebGitController.m
//  GitTest
//
//  Created by Pieter de Bie on 14-06-08.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

#import "PBWebHistoryController.h"

@implementation PBWebHistoryController

@synthesize diff;

- (void) awakeFromNib
{
	startFile = @"history";
	repository = historyController.repository;
	[super awakeFromNib];
	[historyController addObserver:self forKeyPath:@"webCommit" options:0 context:@"ChangedCommit"];
}

- (void) didLoad
{
	currentSha = @"";
	[self changeContentTo: historyController.webCommit];
}

- (void) observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary *)change context:(NSString *)context
{
    if ([context isEqualToString: @"ChangedCommit"])
		[self changeContentTo: historyController.webCommit];
	else
		[super observeValueForKeyPath:keyPath ofObject:object change:change context:context];
}

- (void) changeContentTo: (PBGitCommit *) content
{
	if (content == nil || !finishedLoading)
		return;

	// The sha is the same, but refs may have changed.. reload it lazy
	if ([currentSha isEqualToString: [content realSha]])
	{
		[[self script] callWebScriptMethod:@"reload" withArguments: nil];
		return;
	}
	currentSha = [content realSha];

	NSArray *arguments = [NSArray arrayWithObjects:content, [[[historyController repository] headRef] simpleRef], nil];
	[[self script] callWebScriptMethod:@"loadCommit" withArguments: arguments];
}

- (void) selectCommit: (NSString*) sha
{
	[historyController selectCommit:sha];
}

- (void) sendKey: (NSString*) key
{
	id script = [view windowScriptObject];
	[script callWebScriptMethod:@"handleKeyFromCocoa" withArguments: [NSArray arrayWithObject:key]];
}

- (void) copySource
{
	NSString *source = [(DOMHTMLElement *)[[[view mainFrame] DOMDocument] documentElement] outerHTML];
	NSPasteboard *a =[NSPasteboard generalPasteboard];
	[a declareTypes:[NSArray arrayWithObject:NSStringPboardType] owner:self];
	[a setString:source forType: NSStringPboardType];
}

- (NSArray *)	   webView:(WebView *)sender
contextMenuItemsForElement:(NSDictionary *)element
		  defaultMenuItems:(NSArray *)defaultMenuItems
{
	DOMNode *node = [element valueForKey:@"WebElementDOMNode"];

	// If clicked on the text, select the containing div
	if ([[node className] isEqualToString:@"DOMText"])
		node = [node parentNode];

	// Every ref has a class name of 'refs' and some other class. We check on that to see if we pressed on a ref.
	if (![[node className] hasPrefix:@"refs "])
		return defaultMenuItems;

	NSString *selectedRefString = [[[node childNodes] item:0] textContent];
	for (PBGitRef *ref in historyController.webCommit.refs)
	{
		if ([[ref shortName] isEqualToString:selectedRefString])
			return [contextMenuDelegate menuItemsForRef:ref commit:historyController.webCommit];
	}
	NSLog(@"Could not find selected ref!");

	return defaultMenuItems;
}


// Open external links in the default browser
-   (void)webView:(WebView *)sender decidePolicyForNewWindowAction:(NSDictionary *)actionInformation
   		  request:(NSURLRequest *)request
     newFrameName:(NSString *)frameName
 decisionListener:(id < WebPolicyDecisionListener >)listener
{
	[[NSWorkspace sharedWorkspace] openURL:[request URL]];
}

- getConfig:(NSString *)config
{
	return [historyController valueForKeyPath:[@"repository.config." stringByAppendingString:config]];
}

- (void) finalize
{
	[historyController removeObserver:self forKeyPath:@"webCommit"];
	[super finalize];
}

- (void) preferencesChanged
{
	[[self script] callWebScriptMethod:@"enableFeatures" withArguments:nil];
}

@end
