<!-- Kamailio Pull Request Template -->

<!--
IMPORTANT:
  - for detailed contributing guidelines, read:
    https://github.com/kamailio/kamailio/blob/master/.github/CONTRIBUTING.md
  - pull requests must be done to master branch, unless they are backports
    of fixes from master branch to a stable branch
  - backports to stable branches must be done with 'git cherry-pick -x ...'
  - code is contributed under BSD for core and main components (tm, sl, auth, tls)
  - code is contributed GPLv2 or a compatible license for the other components
  - GPL code is contributed with OpenSSL licensing exception
-->

#### Pre-Submission Checklist
<!-- Go over all points below, and after creating the PR, tick all the checkboxes that apply -->
<!-- All points should be verified, otherwise, read the CONTRIBUTING guidelines from above-->
<!-- If you're unsure about any of these, don't hesitate to ask on sr-dev mailing list -->
- [ ] Commit message has the format required by CONTRIBUTING guide
- [ ] Commits are split per component (core, individual modules, libs, utils, ...)
- [ ] Each component has a single commit (if not, squash them into one commit)
- [ ] No commits to README files for modules (changes must be done to docbook files
in `doc/` subfolder, the README file is autogenerated)

#### Type Of Change
- [ ] Small bug fix (non-breaking change which fixes an issue)
- [ ] New feature (non-breaking change which adds new functionality)
- [ ] Breaking change (fix or feature that would change existing functionality)

#### Checklist:
<!-- Go over all points below, and after creating the PR, tick the checkboxes that apply -->
- [ ] PR should be backported to stable branches
- [ ] Tested changes locally
- [ ] Related to issue #XXXX (replace XXXX with an open issue number)

#### Description
<!-- Describe your changes in detail -->
