/*
Script: Date.German.js
	Date messages for German.

	License:
		MIT-style license.

	Authors: 
		Frank Rossi
		Ulrich Petri

*/

MooTools.lang.set('de-DE', 'Date', {

	months: ['Januar', 'Februar', 'M&auml;rz', 'April', 'Mai', 'Juni', 'Juli', 'August', 'September', 'Oktober', 'November', 'Dezember'],
	days: ['Sontag', 'Montag', 'Dienstag', 'Mittwoch', 'Donnerstag', 'Freitag', 'Samstag'],
	//culture's date order: MM/DD/YYYY
	dateOrder: [ 'date', 'month', 'year', '.'],

	AM: 'vormittags',
	PM: 'nachmittags',

	shortDate: '%d.%m.%Y',
	shortTime: '%H:%M',

	/* Date.Extras */
	ordinal: '.',

	lessThanMinuteAgo: 'Vor weniger als einer Minute',
	minuteAgo: 'Vor ca. einer Minute',
	minutesAgo: 'Vor {delta} Minuten',
	hourAgo: 'Vor ca. einer Stunde',
	hoursAgo: 'Vor ca. {delta} Stunden',
	dayAgo: 'Vor einem Tag',
	daysAgo: 'Vor {delta} Tagen',
	lessThanMinuteUntil: 'In weniger als einer Minute',
	minuteUntil: 'In ca. einer Minute',
	minutesUntil: 'In {delta} Minuten',
	hourUntil: 'In ca. einer Stunde',
	hoursUntil: 'In ca. {delta} Stunden',
	dayUntil: 'In einem Tag',
	daysUntil: 'In {delta} Tagen'

});