/*
---

script: Form.Validator.French.js

description: Form.Validator messages in French.

license: MIT-style license

authors: 
- Miquel Hudin
- Nicolas Sorosac <nicolas <dot> sorosac <at> gmail <dot> com>

requires:
- /Lang
- /Form.Validator

provides: [Form.Validator.French]

...
*/
 
MooTools.lang.set('fr-FR', 'Form.Validator', {
  required:'Ce champ est obligatoire.',
  minLength:'Veuillez saisir un minimum de {minLength} caract&egrave;re(s) (vous avez saisi {length} caract&egrave;re(s)).',
  maxLength:'Veuillez saisir un maximum de {maxLength} caract&egrave;re(s) (vous avez saisi {length} caract&egrave;re(s)).',
  integer:'Veuillez saisir un nombre entier dans ce champ. Les nombres d&eacute;cimaux (ex : "1,25") ne sont pas autoris&eacute;s.',
  numeric:'Veuillez saisir uniquement des chiffres dans ce champ (ex : "1" ou "1,1" ou "-1" ou "-1,1").',
  digits:'Veuillez saisir uniquement des chiffres et des signes de ponctuation dans ce champ (ex : un num&eacute;ro de t&eacute;l&eacute;phone avec des traits d\'union est autoris&eacute;).',
  alpha:'Veuillez saisir uniquement des lettres (a-z) dans ce champ. Les espaces ou autres caract&egrave;res ne sont pas autoris&eacute;s.',
  alphanum:'Veuillez saisir uniquement des lettres (a-z) ou des chiffres (0-9) dans ce champ. Les espaces ou autres caract&egrave;res ne sont pas autoris&eacute;s.',
  dateSuchAs:'Veuillez saisir une date correcte comme {date}',
  dateInFormatMDY:'Veuillez saisir une date correcte, au format JJ/MM/AAAA (ex : "31/11/1999").',
  email:'Veuillez saisir une adresse de courrier &eacute;lectronique. Par example "fred@domaine.com".',
  url:'Veuillez saisir une URL, comme http://www.google.com.',
  currencyDollar:'Veuillez saisir une quantit&eacute; correcte. Par example 100,00&euro;.',
  oneRequired:'Veuillez s&eacute;lectionner au moins une de ces options.',
  errorPrefix: 'Erreur : ',
  warningPrefix: 'Attention : ',
  
  //Form.Validator.Extras
 
  noSpace: 'Ce champ n\'accepte pas les espaces.',
  reqChkByNode: 'Aucun &eacute;l&eacute;ment n\'est s&eacute;lectionn&eacute;.',
  requiredChk: 'Ce champ est obligatoire.',
  reqChkByName: 'Veuillez s&eacute;lectionner un(e) {label}.',
  match: 'Ce champ doit correspondre avec le champ {matchName}.',
  startDate: 'date de d&eacute;but',
  endDate: 'date de fin',
  currendDate: 'date actuelle',
  afterDate: 'La date doit &ecirc;tre identique ou post&eacute;rieure &agrave; {label}.',
  beforeDate: 'La date doit &ecirc;tre identique ou ant&eacute;rieure &agrave; {label}.',
  startMonth: 'Veuillez s&eacute;lectionner un mois de d&eacute;but.',
  sameMonth: 'Ces deux dates doivent &ecirc;tre dans le m&ecirc;me mois - vous devez en modifier une.'
 
});