/*
---

script: Date.Persian.js

description: Date messages for Persian.

license: MIT-style license

authors:
- Amir Hossein Hodjaty Pour

requires:
- /Lang
- /Date

provides: [Date.Persian]

...
*/

MooTools.lang.set('fa', 'Date', {

	months: ['ژانویه', 'فوریه', 'مارس', 'آپریل', 'مه', 'ژوئن', 'ژوئیه', 'آگوست', 'سپتامبر', 'اکتبر', 'نوامبر', 'دسامبر'],
	days: ['یکشنبه', 'دوشنبه', 'سه شنبه', 'چهارشنبه', 'پنجشنبه', 'جمعه', 'شنبه'],
	//culture's date order: MM/DD/YYYY
	dateOrder: ['ماه', 'روز', 'سال'],
	shortDate: '%m/%d/%Y',
	shortTime: '%I:%M%p',
	AM: 'ق.ظ',
	PM: 'ب.ظ',

	/* Date.Extras */
	ordinal: function(dayOfMonth){
		//1st, 2nd, 3rd, etc.
		return 'ام';
	},

	lessThanMinuteAgo: 'کمتر از یک دقیقه پیش',
	minuteAgo: 'حدود یک دقیقه پیش',
	minutesAgo: '{delta} دقیقه پیش',
	hourAgo: 'حدود یک ساعت پیش',
	hoursAgo: 'حدود {delta} ساعت پیش',
	dayAgo: '1 روز پیش',
	daysAgo: '{delta} روز پیش',
	weekAgo: '1 هفته پیش',
	weeksAgo: '{delta} هفته پیش',
	monthAgo: '1 ماه پیش',
	monthsAgo: '{delta} ماه پیش',
	yearAgo: '1 سال پیش',
	yearsAgo: '{delta} سال پیش',
	lessThanMinuteUntil: 'کمتر از یک دقیقه از حالا',
	minuteUntil: 'حدود یک دقیقه از حالا',
	minutesUntil: '{delta} دقیقه از حالا',
	hourUntil: 'حدود یک ساعت از حالا',
	hoursUntil: 'حدود {delta} ساعت از حالا',
	dayUntil: '1 روز از حالا',
	daysUntil: '{delta} روز از حالا',
	weekUntil: '1 هفته از حالا',
	weeksUntil: '{delta} هفته از حالا',
	monthUntil: '1 ماه از حالا',
	monthsUntil: '{delta} ماه از حالا',
	yearUntil: '1 سال از حالا',
	yearsUntil: '{delta} سال از حالا'

});