/*
---

description: Date messages for Japanese.

license: MIT-style license

authors:
- Noritaka Horio

requires:
- /Lang
- /Date

provides: [Date.Japanese]

*/
MooTools.lang.set('ja-JP', 'Date', {

	months: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月', '9月', '10月', '11月', '12月'],
	days: ['日曜日', '月曜日', '火曜日', '水曜日', '木曜日', '金曜日', '土曜日'],
	dateOrder: ['年', '月', '日'],
	shortDate: '%Y/%m/%d',
	shortTime: '%H:%M',
	AM: '午前',
	PM: '午後',

	/* Date.Extras */
	ordinal: '',
 
	lessThanMinuteAgo: '1分以内前',
	minuteAgo: '約1分前',
	minutesAgo: '約{delta}分前',
	hourAgo: '約1時間前',
	hoursAgo: '約{delta}時間前',
	dayAgo: '1日前',
	daysAgo: '{delta}日前',
	weekAgo: '1週間前',
	weeksAgo: '{delta}週間前',
	monthAgo: '1ヶ月前',
	monthsAgo: '{delta}ヶ月前',
	yearAgo: '1年前',
	yearsAgo: '{delta}年前',
	lessThanMinuteUntil: '今から約1分以内',
	minuteUntil: '今から約1分',
	minutesUntil: '今から約{delta}分',
	hourUntil: '今から約1時間',
	hoursUntil: '今から約{delta}時間',
	dayUntil: '今から1日間',
	daysUntil: '今から{delta}日間',
	weekUntil: '今から1週間',
	weeksUntil: '今から{delta}週間',
	monthUntil: '今から1ヶ月',
	monthsUntil: '今から{delta}ヶ月',
	yearUntil: '今から1年',
	yearsUntil: '今から{delta}年'

});
