package main

import (
	"fmt"
	"os"
	"runtime/debug"
)

const genStr = "// Code generated by \"nan %s\"; DO NOT EDIT.\n\n"

func main() {
	var cmd string

	if len(os.Args) > 1 {
		cmd = os.Args[1]
		os.Args = append([]string{os.Args[0]}, os.Args[2:]...)
	}

	switch cmd {
	case "gen":
		generateDefault()
	case "extra":
		generateExtra()
	case "version":
		printVersion()
	default:
		fmt.Println(`
nan gen - generate implementations for the specified marshalers
nan extra - generate marshalers implementations for extra types, defined by user
		`)
	}
}

func printVersion() {
	info, ok := debug.ReadBuildInfo()
	if !ok || info == nil {
		fmt.Println("version not found in build")
	}

	fmt.Println(info.Main.Version)
}
