package main

import (
	"crypto/md5"
	"fmt"
	"io"
	"os"

	"github.com/markbates/pkger"
)

const genStr = "// Code generated by \"nan %s\"; DO NOT EDIT.\n\n"

func main() {
	var cmd string

	if len(os.Args) > 1 {
		cmd = os.Args[1]
		os.Args = append([]string{os.Args[0]}, os.Args[2:]...)
	}

	switch cmd {
	case "gen":
		generateDefault()
	case "extra":
		generateExtra()
	case "checksum":
		generateChecksum()
	default:
		fmt.Println(`
nan gen - generate implementations for the specified marshalers
nan extra - generate marshalers implementations for extra types, defined by user
		`)
	}
}

func generateChecksum() {
	files := []string{
		pkger.Include("/nan.go"),
		pkger.Include("/helpers.go"),
		pkger.Include("/LICENSE"),
		pkger.Include("/cql.go"),
		pkger.Include("/cql_helpers.go"),
		pkger.Include("/easyjson.go"),
		pkger.Include("/json.go"),
		pkger.Include("/jsoniter.go"),
		pkger.Include("/sql.go"),
		pkger.Include("/sql_convert.go"),
		pkger.Include("/text.go"),
	}

	sum := md5.New()

	for i := range files {
		in, err := pkger.Open(files[i])
		if err != nil {
			panic(err)
		}

		_, err = io.Copy(sum, in)
		if err != nil {
			panic(err)
		}

		in.Close()
	}

	fmt.Printf("%x\n", sum.Sum(nil))
}
