import {Plugin, IPlugin, IPluginFormFields} from './plugin';

// Classname must be same as the CRD's Name
export class Cockroachdb extends Plugin implements IPlugin {
    public id: string = 'cockroachdb';//same as operator name
    public displayName = 'CockroachDB'
    public icon = '/img/addons/CockroachDB.svg'
    public install: string = 'kubectl create -f https://operatorhub.io/install/cockroachdb.yaml'
    public install_olm: string = 'kubectl create -f https://operatorhub.io/install/cockroachdb.yaml'
    public url = 'https://artifacthub.io/packages/olm/community-operators/cockroachdb'
    public docs = [
        {
            title: 'Kubero Docs', url: ''
        }
    ]
    public artifact_url = 'https://artifacthub.io/api/v1/packages/olm/community-operators/mongodb-operator'
    public beta: boolean = true;

    public formfields: {[key: string]: IPluginFormFields} = {
        'Cockroachdb.metadata.name':{
            type: 'text',
            label: 'MongoDB Name',
            name: 'MongoDB.metadata.name',
            required: true,
            default: 'mongodbinstance',
            description: 'The name of the MongoDB cluster'
        },
        'Cockroachdb.conf.cache':{
            type: 'text',
            label: 'Cache Size',
            name: 'Cockroachdb.conf.cache',
            required: true,
            default: '25%',
            description: 'Size of the cache'
        },
        'Cockroachdb.conf.max-sql-memory':{
            type: 'text',
            label: 'Max SQL Memory',
            name: 'Cockroachdb.conf.max-sql-memory',
            required: true,
            default: '25%',
            description: 'Max SQL Memory'
        },
        'Cockroachdb.conf.single-node':{
            type: 'switch',
            label: 'Single Node',
            name: 'Cockroachdb.conf.single-node',
            required: false,
            default: false,
            description: 'Single Node'
        },
        'Cockroachdb.statefulset.replicas':{
            type: 'number',
            label: 'Replicas',
            name: 'Cockroachdb.statefulset.replicas',
            required: true,
            default: 3,
            description: 'Number of Replicas'
        },
        'Cockroachdb.spec.storage.persistentVolume.storageSize':{
            type: 'text',
            label: 'Sorage Size',
            name: 'MongoDB.spec.storage.storageSize',
            default: '1Gi',
            required: true,
            description: 'Size of the storage'
        },
        'Cockroachdb.spec.storage.persistentVolume.storageClass':{
            type: 'select-storageclass',
            label: 'Sorage Class',
            name: 'MongoDB.spec.storage.storageClass',
            default: 'standard',
            required: true,
            description: 'Classname of the storage'
        },
    };

    public env: any[] = []

    protected additionalResourceDefinitions: Object = {}

    constructor(availableOperators: any) {
        super();
        super.init(availableOperators);
    }

    public resourceDefinitions: any = {
        'Cockroachdb': {
            apiVersion: "charts.operatorhub.io/v1alpha1",
            kind: "Cockroachdb",
            metadata: {
              name: "cockroachdbinstance",
            },
            spec: {
              cache: "25%",
              'max-sql-memory': "25%",
              'single-node': false,
              statefulset: {
                replicas: 3
              },
              storage: {
                persistentVolume: {
                  storageSize: "1Gi",
                  storageClass: "standard"
                }
              }
            }
        }
    }

}



