=begin
JRubyFX - Write JavaFX and FXML in Ruby
Copyright (C) 2013 The JRubyFX Team

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=end

# This class is used to work with JavaFX objects on the proper thread
class ReflectGenerator < javafx.application.Application
  def start(stage)
 
 # Generate DSL table
  File.open("lib/jrubyfx/dsl_map.rb", "w") do |out|
    out << <<'ENDL'
=begin
JRubyFX - Write JavaFX and FXML in Ruby
Copyright (C) 2013 The JRubyFX Team

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=end

# DO NOT MODIFY THIS FILE!
# This file is generated by the `rake reflect` task.

module JRubyFX
  module DSL
    NAME_TO_CLASSES = {
      # Manual overrides
      'observable_array_list' => proc { |*args| FXCollections.observable_array_list(*args) },
      'double_property' => Java::JavafxBeansProperty::SimpleDoubleProperty,
      'xy_chart_series' => Java::javafx.scene.chart.XYChart::Series,
      'xy_chart_data' => Java::javafx.scene.chart.XYChart::Data,
      # Automatically generated
    }
    NAME_TO_CLASS_NAME = {
ENDL
    # import for our needs
    (JRubyFX::FXImports::JFX_CLASS_HIERARCHY.flat_tree_inject do |res, name, values|
        name = "#{name.to_s}."
        name = "" if name == "."
        res.concat(values.map{|i| "#{name}#{i}"})
      end).map{|x| java_import x}

    out << (JRubyFX::FXImports::JFX_CLASS_HIERARCHY.flat_tree_inject(Hash) do |res, name, values|
        # Merge in auto-generated list of classes from all the imported classes
        unless values.is_a? Hash
          values.map do |i|
            # this regexp does snake_casing
            # TODO: Better way to get FULL class name
            res.merge!({i.snake_case.gsub(/(h|v)_(line|box)/, '\1\2') => i})
          end
          res
        else
          # we are not at a leaf node anymore, merge in previous work
          res.merge!(values)
        end
      end).map {|k, v| "      '#{k}' => #{eval(v).to_s.inspect},"}.join("\n")

    # Add the custom ones
    out << <<'ENDL'

    }
  end
end
ENDL
  end

  # JRubyFX includes
  require_relative 'lib/jrubyfx/imports'
  require_relative 'lib/jrubyfx/module'
  require_relative 'lib/jrubyfx/dsl'
  fo = File.open("lib/jrubyfx/core_ext/precompiled.rb", "w")
  JRubyFX::DSL.compile_dsl(fo)
  fo.flush
  fo.close
  puts "Done Writing jrfx!"
  Platform.exit
  end
end

  require_relative 'lib/jrubyfx/java_fx_impl'
JavaFXImpl::Launcher.launch_app(ReflectGenerator)