#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# Skan documentation build configuration file, created by
# sphinx-quickstart on Tue Dec 12 15:07:05 2017.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
# Add the local code to the Python path, so docs are generated for
# current working copy
import os
import re
import sys

rundir = os.path.dirname(__file__)
sys.path.insert(0, os.path.abspath(rundir + '/..'))

# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
# needs_sphinx = '1.0'

# Execution options
execution_timeout = 300  # in seconds?

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
        'sphinx.ext.autodoc',
        'sphinx.ext.mathjax',
        'sphinx.ext.viewcode',
        'sphinx.ext.githubpages',
        'sphinx.ext.napoleon',
        'sphinxcontrib.bibtex',
        'sphinx_copybutton',
        'myst_nb',
        ]

# sphinx-copybutton prompt-stripping configuration
copybutton_prompt_text = r">>> |\.\.\. |\$ |In \[\d*\]: | {2,5}\.\.\.: | {5,8}: "
copybutton_prompt_is_regexp = True

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = 'Skan 🦴📏'
copyright = '2021, Juan Nunez-Iglesias & skan contributors'
author = 'Juan Nunez-Iglesias'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
import skan

version = skan.__version__
# The full version, including alpha/beta/rc tags.
release = skan.__version__

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = False

# List of publications
bibtex_bibfiles = ['publications.bib']

# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.

html_theme = 'pydata_sphinx_theme'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#

# Version match must match the 'version' key in version_swticher.json
pattern = re.compile(r'^[0-9]+\.[0-9]+')
version_match = pattern.search(version)
if 'dev' in version:
    version_match = version
elif version_match:
    version_match = version_match.group() + ".x"

# PyData theme options (see theme.conf for more information)
html_theme_options = {
    # Set the name of the project to appear in the navigation.
    'navbar_end': ['version-switcher', 'navbar-icon-links'],
    # pydata theme version switcher config
    'switcher': {
        'json_url': 'https://skeleton-analysis.org/dev/_static/version_switcher.json',
        'version_match': version_match,
    },
    # footer
    'footer_items': ['copyright'],
    'icon_links': [{'name': 'GitHub', 'url': 'https://github.com/jni/skan',
            'icon': 'fa-brands fa-square-github', 'type': 'fontawesome'}]
}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# -- Options for HTMLHelp output ------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'Skandoc'

# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
        # The paper size ('letterpaper' or 'a4paper').
        #
        # 'papersize': 'letterpaper',

        # The font size ('10pt', '11pt' or '12pt').
        #
        # 'pointsize': '10pt',

        # Additional stuff for the LaTeX preamble.
        #
        # 'preamble': '',

        # Latex figure (float) alignment
        #
        # 'figure_align': 'htbp',
        }

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
        (
                master_doc, 'Skan.tex', 'Skan Documentation',
                'Juan Nunez-Iglesias', 'manual'
                ),
        ]

# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [(master_doc, 'skan', 'Skan Documentation', [author], 1)]

# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
        (
                master_doc, 'Skan', 'Skan Documentation', author, 'Skan',
                'Skeleton analysis in Python.', 'Miscellaneous'
                ),
        ]
