import buble from 'rollup-plugin-buble'
import json from 'rollup-plugin-json'
import nodeResolve from 'rollup-plugin-node-resolve'
import strip from 'rollup-plugin-strip'
import uglify from 'rollup-plugin-uglify'
import banner from './rollup.conf.banner'

export default {
	input: 'src/index.js',
	plugins: [
		json(),
		nodeResolve(),
		buble(),
		strip({
			functions: ['logger'],
			sourceMaps: false
		}),
		uglify({
			output: {
				comments: /@license ScrollReveal/
			}
		})
	],
	output: {
		banner,
		format: 'iife',
		file: 'dist/scrollreveal.min.js',
		name: 'ScrollReveal'
	}
}
