---
title: 'Jest 29: Snapshot format changes'
authors: simenb
---

Jest 29 is here, just a few short months after Jest 28. As mentioned in the [Jest 28 blog post](/blog/2022/04/25/jest-28#future), this version contains just a couple of breaking changes, in order to make the upgrade as smooth as possible.

<!--truncate-->

The only breaking changes that should be noticeable are:

- Node versions 12 and 17 are dropped, both of which are EOL
- The `snapshotFormat` property is changed to:

  ```diff
  + snapshotFormat: {
  +   escapeString: false,
  +   printBasicPrototype: false
  + }
  ```

- `jest-environment-jsdom` has upgraded `jsdom` from v19 to v20

There are certain changes to the types exposed by Jest, but probably (hopefully!) nothing that should impede the upgrade. Please see the [upgrade guide](/docs/upgrading-to-jest29) for more details.

That's it for breaking changes! Hopefully this means the upgrade path from Jest 28 is smooth. Please see the [changelog](https://github.com/jestjs/jest/blob/main/CHANGELOG.md#2900) for other changes.

Thanks for reading, and happy Jesting! 🃏
