---
title: 'Jest 26: Tick Tock'
authors: cpojer
---

When we started rebuilding Jest five years ago our goal was to provide a batteries-included zero-configuration test runner that is approachable for beginners, extensible for almost all testing use cases and scalable to large projects. One of the instrumental releases was [Jest 15](/blog/2016/09/01/jest-15) which tied everything together and provided good defaults that allowed people to run Jest often without any setup. However, this approach has a big downside as Jest installs a lot of dependencies into your projects that you may not need.

We are now beginning to address this shortcoming and are working on reducing Jest’s install size while keeping it approachable and extensible. We have made the following **breaking changes** in Jest 26:

<!--truncate-->

- `[expect, jest-mock, pretty-format]` Remove `ES5` build files with a new minimum of support of ES2015 (Node 8) which were only used for browser builds ([#9945](https://github.com/jestjs/jest/pull/9945))

  > **Migration**: With this change, we are pushing the responsibility to bundle the affected packages to the users, rather than Jest providing them out of the box, since they know their target environments best. If you want it back, we're open to shipping these as separate packages. PRs welcome!

- `[jest-config, jest-resolve]` Remove support for `browser` field ([#9943](https://github.com/jestjs/jest/pull/9943))

  > **Migration**: Install `browser-resolve` module and use the following configuration:

  ```json
  {
    "jest": {
      "resolver": "<rootDir>/resolver.js"
    }
  }
  ```

  ```js
  // resolver.js
  const browserResolve = require('browser-resolve');

  module.exports = browserResolve.sync;
  ```

- TypeScript definitions requires a minimum of TypeScript v3.8 ([#9823](https://github.com/jestjs/jest/pull/9823))

With the above changes Jest 26 is now 4 MiB smaller than Jest 25.5.4 (53 → 49 MiB). Please keep in mind that many dependencies like Babel are likely already part of your project. Jest's own size was reduced by 1.2 MiB (4.3 -> 3.1 MiB).

While this is a good start, it isn’t enough to make Jest meaningfully leaner. We are planning on gradually reducing Jest's and its dependency tree size by up to 70%. Most of the changes to reduce Jest’s default setup will be small breaking changes and we want to bring the community with us as much as possible. Therefore we will make the following changes in Jest 27 and Jest 28 using a [“Tick-Tock" release process](https://en.wikipedia.org/wiki/Tick%E2%80%93tock_model):

- Jest 27 will ship with a new test runner "`jest-circus`" and the Node.js environment by default. `jest-jasmine2` and `jest-environment-jsdom` will still be bundled so users can keep using them by changing one-line each in the configuration.
- Jest 28 will remove `jest-jasmine2` and `jest-environment-jsdom` from the default distribution of Jest. The packages will still be actively maintained as part of the Jest project and be published separately. Users will need to install these packages to use them.

Upon upgrading to these major releases, Jest will guide you through the necessary changes. If you’d like to get ahead and migrate to the new defaults now, and your project does not require a DOM environment, you can upgrade to Jest 26 and add the following configuration options:

```json
{
  "jest": {
    "testEnvironment": "node",
    "testRunner": "jest-circus/runner"
  }
}
```

Jest will continue to ship with `babel-jest` enabled by default. It currently powers a few Jest features beyond compiling modern JavaScript syntax to something understood by current versions of Node.js and browsers: It also powers Jest's code coverage and mocking of ES modules. Jest currently ships with experimental support for [V8 coverage](/blog/2020/01/21/jest-25#v8-code-coverage) and native support for ES Modules (more on that below!). It is not possible to mock static ES Modules per the specification without transforming the code first, so we will be encouraging patterns that work without the transformation we use Babel for today. Once V8 coverage and native ESM support stabilizes in Jest, we will also be able remove `babel-jest` as a default but we will keep maintaining it.

## New fake timers

With Jest 26 we are shipping a new implementation of fake timers based on `@sinonjs/fake-timers`. We've wanted to do this for years and are happy this has finally progressed far enough to support all of Jest's existing fake timer use cases.

The new implementation comes with extra features such as mocking `Date`, `queueMicrotask` and more, see [this README](https://github.com/sinonjs/fake-timers/blob/master/README.md). It works transparently using the existing timer APIs like `jest.runAllTimers()` – check out the documentation [on our website](/docs/timer-mocks).

We are confident this implementation is ready for prime time, however we don't want to force people to rewrite their tests if they depend on subtle differences between the old and new implementation. In Jest 26, this new implementation will remain _opt-in_ and can be activated by calling `jest.useFakeTimers('modern')` or by passing `modern` to the `timers` option in your config if you opted all tests into fake timers previously.

In Jest 27 we will swap the default to the new "modern" implementation but we will keep supporting and maintaining the legacy implementation which can be used by calling `jest.useFakeTimers('legacy')`. If you are unsure whether you'll be able to upgrade all your tests by the time Jest 27 rolls out, you can add this to your tests now to keep the old behavior.

We'd like to thank [Carl-Erik Kopseng](https://github.com/fatso83), [Benjamin Gruenbaum](https://github.com/benjamingr) and other maintainers of `@sinonjs/fake-timers` for their help and patience when working with us to make this happen! _Exciting_.

## A new way to consume Jest - `@jest/globals`

Jest has relied on globals popularized by the Jasmine testing framework and others such as `describe`, `it`, `test` and `expect`. While this is a widely used pattern, many people have expressed their preference for importing testing related functions instead. To support this use case, we added a new package `@jest/globals` that can be used to import testing functions: `import {expect, jest, test} from '@jest/globals';`.

Caveats:

- Currently the globals still exist in the environment but we will introduce a mode to disable globals in the future. Similarly, you cannot use `const jest = require('@jest/globals')` as you'll get declaration errors because the `jest` variable is still a global for now.
- There is currently no way to add custom matchers to the TypeScript definitions when using globals like this.
- While this allows running tests without globals, it does not allow running tests without Jest's test runner at this time.

## Native ESM support

As mentioned in the [Jest 25 blog post](/blog/2020/01/21/jest-25#ecmascript-modules-support) we have been working on native support for ECMAScript Modules. It is not stable yet but it is ready to be tested. We'd love to hear your feedback and bug reports! For an overview of the current state you can check out [this issue](https://github.com/jestjs/jest/issues/9430), or browse all issues with that label [ES Modules](https://github.com/jestjs/jest/labels/ES%20Modules).

## Other Breaking Changes in Jest 26

- Dropped support for Node 8 ([#9423](https://github.com/jestjs/jest/pull/9423))
- `[jest-environment-jsdom]` Upgrade `jsdom` to v16 ([#9606](https://github.com/jestjs/jest/pull/9606))
- `[jest-runtime]` Remove long-deprecated `require.requireActual` and `require.requireMock` methods ([#9854](https://github.com/jestjs/jest/pull/9854))
- `[jest-haste-map]` Removed `providesModuleNodeModules` ([#8535](https://github.com/jestjs/jest/pull/8535))
- `[jest-circus]` Fail tests if a test takes a done callback and have return values ([#9129](https://github.com/jestjs/jest/pull/9129))
- `[jest-circus]` Throw a proper error if a test / hooks is defined asynchronously ([#8096](https://github.com/jestjs/jest/pull/8096))

## Stay Safe

We are all currently experiencing an unprecedented time of uncertainty. If you are struggling financially, we would like to use [Jest’s Open Collective fund](https://opencollective.com/jest) to help new and existing contributors. We place [bounties on some issues](https://github.com/jestjs/jest/issues?q=is%3Aissue+is%3Aopen+bounty+label%3A%22Has+Bounty%22) and are open to offering a bounty on any of our current open issues - you can mention that an issue should have a bounty in the issue or contact [@cpojer via private message on Twitter](https://twitter.com/cpojer).

Please stay safe.
