---
title: 'Jest 16.0: Turbocharged CLI & Community Update'
authors: cpojer
---

It's been one month since the last major release and we've made significant improvements to Jest since. In this major release we are updating the snapshot format we are using which will likely require snapshots to be updated when upgrading Jest. We don't make these changes lightly and don't expect this to happen often but we think it is necessary to improve the format from time to time.

## Upgraded CLI

![reporter](/img/blog/16-reporter.gif)

Jest 16 features a new reporter interface that shows running tests as well as a live summary and a progress bar based on the estimated test runtime from previous test runs. We also improved the CLI output to work better with different color schemes. If there were test failures in a previous run, Jest will now always run those tests first to give useful signal to users as quickly as possible.

<!--truncate-->

We also added a lot of new features which you may find useful:

- New CLI flags were added: A `--testNamePattern=pattern` or `-t <pattern>` option was added to filter tests from the command line much like `it.only` or `fit` does in tests.
- Previously failed tests now always run first.
- `jest <pattern>` is now case-insensitive to make it easier to filter test files.
- A test run in watch mode can now be interrupted. During a test run, simply press any of the keys used for input during watch mode (`a`, `o`, `p`, `q` or `enter`) to abort a test run and start a new one.
- The `--bail` flag now also works in watch mode. Together with running failed tests first, Jest's watch mode will now feel turbocharged!
- Jest now automatically considers files and tests with the `jsx` extension.
- Jest warns about duplicate manual mock files and we improved automatically created mocks for ES modules compiled with babel.
- A `jest.clearAllMocks` function was added to clear all mocks in between tests.
- We improved module resolution when `moduleNameMapper` is used.
- Finally, a `--findRelatedTests <fileA> <fileB>` cli option was added to run tests related to the specified files. This is especially helpful as a pre-commit hook if you'd like to run tests only on a specified set of files that have tests associated with them.

This is what Jest looks like when a test run is interrupted in watch mode: ![watch](/img/blog/16-watch.gif)

## Snapshot Updates

Jest's snapshot implementation was completely rewritten. The new version of the `jest-snapshot` package is now structured in a way that allows for easier integration into other test runners and enables more cool integrations like with [React Storybook](https://voice.kadira.io/snapshot-testing-in-react-storybook-43b3b71cec4f#.qh4lzcadb). Jest doesn't mark snapshots as obsolete in a file with skipped or failing tests. We also made a number of changes to the snapshot format:

- Objects and Arrays are now printed with a trailing comma to minimize future changes to snapshots.
- We removed function names from snapshots. They were causing issues with different versions of Node, with code coverage instrumentation and we generally felt like it wasn't useful signal to show to the user that the name of a function has changed.
- Snapshots are now sorted using natural sort order within a file.

When upgrading to Jest 16, the diff might look similar to this one: ![snapshots](/img/blog/16-snapshots.png)

## Test Library Updates

We finished the migration of Jasmine assertions to the new Jest matchers. We added three new matchers: `toBeInstanceOf`, `toContainEqual` and `toThrowErrorMatchingSnapshot` . We have more readable failure messages for the spy/mock matchers `toHaveBeenLastCalledWith`, `toHaveBeenCalledWith`, `lastCalledWith` and `toBeCalledWith`. Now that we have rewritten all assertions and separated them into their own package, we'll be working on making them standalone so they can be integrated into any test framework if you'd like to use them outside of Jest.

We also added a bunch of aliases that were requested by the community. To make Jest focus on a single test you can now use either `it.only` or `test.only` or keep using `fit`; For skipping a test, `it.skip` or `test.skip` are now available alongside of `xit`; finally to define a test as concurrent you can use `test.concurrent` which is useful in case your test accesses network resources or databases.

Finally, if you'd like to overwrite the `expect` global with a different assertion library like [chai](http://chaijs.com/), this can now be done using the `setupTestFrameworkScriptFile` configuration option.

## Community Update

Over the last month lots of articles were written about Jest's snapshot testing feature, how to migrate to Jest and how to get started writing tests. I also did a few live videos to explain how Jest and snapshot testing works:

- [FB Live Video about Snapshot Testing](https://www.facebook.com/react/videos/1035427199869020/).
- [JavaScript & React Testing with Kent C. Dodds](https://www.youtube.com/watch?v=i31VtyJSM-I&feature=youtu.be).

A number of people wrote articles about snapshot testing. The most opinionated article that resonated with the Jest team was “[Testing with Jest Snapshots: First Impressions](http://benmccormick.org/2016/09/19/testing-with-jest-snapshots-first-impressions/)”. Ben makes three great points in his blog post:

1.  Snapshot tests are a complement for conventional tests not a replacement.
2.  Snapshot tests are more useful with a healthy code review process.
3.  Snapshot tests work well with auto-mocking.

We highly recommend reading the entire blog post. Ben did a fantastic job explaining the reasons why we built snapshot testing. It's important to point out that we didn't introduce snapshot testing to replace all other forms of testing but rather as a way to enable engineers to write tests for code that they otherwise wouldn't write tests for. It works well for things like React components, CLI output, error messages and many others but it doesn't solve all problems. Jest's goal is to provide many different ways to write effective tests without sacrificing performance or the project's maintainability.

Other highlights about snapshot testing:

- A React Native testing series: [Part 1: Jest – Snapshot come into play](https://blog.callstack.io/unit-testing-react-native-with-the-new-jest-i-snapshots-come-into-play-68ba19b1b9fe) and [Part 2: Jest – Redux Snapshots for your Actions and Reducers](https://blog.callstack.io/unit-testing-react-native-with-the-new-jest-ii-redux-snapshots-for-your-actions-and-reducers-8559f6f8050b#.putt9eipm).
- [How we landed on Jest snapshot testing for JavaScript](https://blog.grommet.io/post/2016/09/01/how-we-landed-on-jest-snapshot-testing-for-javascript).
- [Picture This: Snapshot Testing](http://guigrpa.github.io/2016/09/27/picture-this-snapshot-testing/).
- [Snapshot testing with React Storybook](https://voice.kadira.io/snapshot-testing-in-react-storybook-43b3b71cec4f).
- [Testing React and Redux Applications](https://medium.com/@ryancollinsio/testing-react-redux-applications-fee79ac0087f#.lyjl7st1n).
- If you are using the popular [enzyme](https://github.com/airbnb/enzyme) testing utility, there is now a project [enzyme-to-json](https://github.com/trayio/enzyme-to-json) which makes it possible to use Jest's snapshot testing feature together with enzyme.

[Redux itself now uses Jest](https://github.com/reactjs/redux/commit/7296d3cba1f5f899bdee5ef6695a8d21149f8d6c) and Max Stoiber wrote a [tutorial on how to test code written with redux](http://academy.plot.ly/react/6-testing/). There is also a great [guide on how to write tests for MobX](https://semaphoreci.com/community/tutorials/how-to-test-react-and-mobx-with-jest). If you are using [create-react-app](https://github.com/facebookincubator/create-react-app), Jest is now included by default. Kent C. Dodds created a ton of [videos on egghead.io](https://egghead.io/lessons/javascript-use-jest-s-snapshot-testing-feature?pl=testing-javascript-with-jest-a36c4074) that will help you get started with Jest.

If you are using other test runners, Kenneth Skovhus built an awesome [jest-codemods](https://github.com/skovhus/jest-codemods) library that will automate the conversion for you. Codemods are awesome: they'll allow you to quickly evaluate whether Jest will work for you. Give it a try!

The full [changelog can be found on GitHub](https://github.com/jestjs/jest/blob/main/CHANGELOG.md#jest-1600). Jest 16 was a true JavaScript community effort and the project now has more than 220 contributors. We thank each and every one of you for your help to make this project great.
