---
title: Jest 11.0
authors: cpojer
---

Today we're announcing a switch to major revisions for Jest with Jest 11.0 being the first major release. Jest has been used by Facebook engineers and on our continuous integration systems for years and we believe Jest has been way beyond a “1.0 release” for a long time. This is similar to a change [the React team has made](http://facebook.github.io/react/blog/2016/02/19/new-versioning-scheme.html).

If you are using Jest 0.9 or Jest 0.10 the upgrade should be seamless. All changes from the last few months were rolled into Jest 11.0.

### New in Jest 11.0

#### Babel Integration and Simplified Setup

`babel-jest` was adopted within the newly modularized Jest [repository](https://github.com/jestjs/jest/tree/main/packages) and it is now seamlessly integrated into Jest. If you are upgrading from an older version of Jest or are looking to adopt Jest, we recommend reading the [Getting Started guide](/docs/getting-started).

<!--truncate-->

Previously Jest provided APIs such as `jest.dontMock` which unmocks a module that is subsequently being required using the `require` function. Testing code usually looked like this:

```javascript
jest.dontMock('LikeButton');
const LikeButton = require('LikeButton'); // LikeButton is unmocked
```

However, together with ES2015 import statements this will no longer work. Per the specification `import`s are hoisted to the top of their code block. Code written like this:

```javascript
jest.dontMock('LikeButton');
import LikeButton from 'LikeButton';
```

when executed, would actually be run in this order:

```javascript
import LikeButton from 'LikeButton'; // This happens before the dontMock call.
jest.dontMock('LikeButton');
```

The LikeButton module would therefore be mocked even though we explicitly call `dontMock`.

When the latest versions of Jest and babel-jest are used together, calls to the new APIs `jest.unmock`, `jest.mock`, `jest.disableAutomock` and `jest.enableAutomock` are hoisted to the top of their block, before ES2015 import statements.

```javascript
jest.unmock('LikeButton');
import LikeButton from 'LikeButton'; // LikeButton is properly unmocked!
```

#### (Auto)Mocking Improvements

We have made numerous improvements and bug fixes to Jest's automocking feature, improved npm3 support and added new manual mocking APIs. Many people have expressed a desire use Jest with the automocking feature disabled. A global configuration option [`automock`](/docs/api#automock-boolean), which can be set to `false`, was added.

We have also added two new APIs to simplify manual mocks. `jest.mock` specifies a manual mock factory for a specific test:

```js
// Implement a mock for a hypothetical "sum" module.
jest.mock('sum', () => {
  return (a, b) => a + b;
});

const sum = require('sum');
sum(1, 4); // 5
```

And `jest.fn` was added to make it easier to create mock functions:

```js
// Create a mock function
const mockFn = jest.fn(() => 42);
mockFn(); // 42
expect(mockFn.calls.length).toBe(1);
```

#### Performance

We recently wrote about some [performance improvements](/blog/2016/03/11/javascript-unit-testing-performance) we've made in Jest. Most notably, startup time has been improved and we are now in a comfortable place with regards to performance.

#### Jasmine and Test Assertion Improvements

When Jest was open sourced it shipped with Jasmine 1. Jest was designed to work with any test assertion library and optional Jasmine 2 support was added through an [external contribution](https://github.com/jestjs/jest/pull/330) at the end of last year. This change delivers better performance and provides a better APIs over the previous version of Jasmine. As such, we have converted all our JavaScript tests at Facebook to Jasmine 2. With Jest 11 we are making Jasmine 2 the new default. Jasmine 1 can be enabled through the [`testRunner`](/docs/api#testrunner-string) configuration option.

We have also made many updates around Jasmine. The failure messages for custom matchers provided for Jest's mock functions were improved and will now also work for Jasmine spies. Skipped tests, when using `fit` or `fdescribe,` are now properly reported at the end of a test run.

#### Other Changes

The `jest --watch` command has been rewritten and improved. By default it now only runs tests related to changed files. If you want to run all tests on every change, you can run `jest --watch=all`. The verbose logger output has also been improved and we've added more helpful warnings and error messages. We added a [`testEnvironment`](/docs/api#testenvironment-string) configuration option to customize the test environment. For example, when building a node service, a special `node` environment instead of `jsdom` can be used. Finally, the website and all documentation have been completely rewritten.

All changes from the past few months can be found in the [CHANGELOG](https://github.com/jestjs/jest/blob/main/CHANGELOG.md).

### Contributions And Jest's future

Over the last six months, Jest has received significant changes from a huge number of new contributors. I'd like to thank all the open source contributors and Facebook employees for their help in making Jest better for everyone. New contributors: Alexander Juarez, Christian Lentfort, Cristian Carlesso, Dan Abramov, Dmitrii Abramov, Evan Jacobs, James Friend, James Ide, Jeff Carpenter, Joe Lencioni, Michael Diolosa, Nik Graf, Pavel Prokopenko, Pavel Volokitin, Sebastian Mayr and ShihChi Huang.

With your support we are looking forward to making Jest even better in the coming months. We are currently working on improved React (Native) testing, enhanced code coverage support and are planning to open source our internal test runner that allows multiple Jest projects to be run with a single run-command.
