/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.equivalence;

import java.util.HashSet;
import java.util.Set;
import org.jgrapht.experimental.equivalence.EquivalenceComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquivalenceSet<E, C> {
    protected EquivalenceComparator<? super E, ? super C> eqComparator;
    protected C comparatorContext;
    protected Set<E> elementsSet;

    private EquivalenceSet() {
    }

    public EquivalenceSet(E e, EquivalenceComparator<? super E, ? super C> equivalenceComparator, C c) {
        this.eqComparator = equivalenceComparator;
        this.comparatorContext = c;
        this.elementsSet = new HashSet();
        this.elementsSet.add(e);
    }

    public E getRepresentative() {
        return this.elementsSet.iterator().next();
    }

    public C getContext() {
        return this.comparatorContext;
    }

    public int size() {
        return this.elementsSet.size();
    }

    public void add(E e) {
        this.elementsSet.add(e);
    }

    public boolean equivalentTo(E e, C c) {
        boolean bl = this.eqComparator.equivalenceCompare(this.getRepresentative(), e, this.comparatorContext, c);
        return bl;
    }

    public boolean equals(Object object) {
        Object e = null;
        Object c = null;
        if (!(object instanceof EquivalenceSet)) {
            throw new ClassCastException("can check equal() only of EqualityGroup");
        }
        e = ((EquivalenceSet)object).getRepresentative();
        c = ((EquivalenceSet)object).getContext();
        boolean bl = this.eqComparator.equivalenceCompare(this.getRepresentative(), e, this.comparatorContext, c);
        return bl;
    }

    public int hashCode() {
        int n = this.eqComparator.equivalenceHashcode(this.getRepresentative(), this.comparatorContext);
        return n;
    }

    public String toString() {
        return "Eq.Group=" + this.elementsSet.toString();
    }

    public Object[] toArray() {
        return this.elementsSet.toArray();
    }
}

