/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.CallInfo;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Foreign;
import com.kenai.jffi.Type;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CallContext
implements CallInfo {
    private final long contextAddress;
    private volatile boolean disposed = false;
    private final int parameterCount;
    private final int rawParameterSize;
    final Type returnType;
    final Type[] parameterTypes;
    final long[] parameterTypeHandles;
    final int flags;
    private final Foreign foreign = Foreign.getInstance();

    public CallContext(Type returnType, Type ... paramTypes) {
        this(returnType, paramTypes, CallingConvention.DEFAULT, true);
    }

    public CallContext(Type returnType, Type[] paramTypes, CallingConvention convention) {
        this(returnType, paramTypes, convention, true);
    }

    public CallContext(Type returnType, Type[] paramTypes, CallingConvention convention, boolean saveErrno) {
        int flags = (!saveErrno ? 2 : 0) | (convention == CallingConvention.STDCALL ? 1 : 0);
        long h = this.foreign.newCallContext(returnType.handle(), Type.nativeHandles(paramTypes), flags);
        if (h == 0L) {
            throw new RuntimeException("Failed to create native function");
        }
        this.contextAddress = h;
        this.returnType = returnType;
        this.parameterTypes = (Type[])paramTypes.clone();
        this.parameterCount = paramTypes.length;
        this.rawParameterSize = this.foreign.getFunctionRawParameterSize(h);
        this.parameterTypeHandles = Type.nativeHandles(paramTypes);
        this.flags = flags;
    }

    public final int getParameterCount() {
        return this.parameterCount;
    }

    public final int getRawParameterSize() {
        return this.rawParameterSize;
    }

    final long getAddress() {
        return this.contextAddress;
    }

    public final Type getReturnType() {
        return this.returnType;
    }

    public final Type getParameterType(int index) {
        return this.parameterTypes[index];
    }

    public final synchronized void dispose() {
        if (this.disposed) {
            throw new RuntimeException("context already freed");
        }
        this.foreign.freeCallContext(this.contextAddress);
        this.disposed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.contextAddress != 0L && !this.disposed) {
                this.foreign.freeCallContext(this.contextAddress);
            }
        }
        catch (Throwable t) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Exception when freeing CallContext: %s", t.getLocalizedMessage());
        }
        finally {
            super.finalize();
        }
    }
}

