# Chromium Development

> A collection of resources for learning about Chromium and tracking its development.

See also [V8 Development](v8-development.md)

## Contributing to Chromium

- [Checking Out and Building](https://chromium.googlesource.com/chromium/src/+/main/docs/#checking-out-and-building)
  - [Windows](https://chromium.googlesource.com/chromium/src/+/main/docs/windows_build_instructions.md)
  - [macOS](https://chromium.googlesource.com/chromium/src/+/main/docs/mac_build_instructions.md)
  - [Linux](https://chromium.googlesource.com/chromium/src/+/main/docs/linux/build_instructions.md)

- [Contributing](https://chromium.googlesource.com/chromium/src/+/refs/heads/main/docs/contributing.md) - This document outlines the process of getting a code change merged to the Chromium source tree.
  - Assumes a working Chromium checkout and build.

## Resources for Chromium Development

### Code Resources

- [Code Search](https://source.chromium.org/chromium) - Indexed and searchable source code for Chromium and associated projects.
- [Source Code](https://source.chromium.org/chromium/chromium/src) - The source code for Chromium itself.
- [Chromium Review](https://chromium-review.googlesource.com) - The searchable code host which facilitates code reviews for Chromium and related projects.

### Informational Resources

- [Chromium Dash](https://chromiumdash.appspot.com/home) - Chromium Dash ties together multiple data sources in order to present a consolidated view of what's going on in Chromium and Chrome, plus related projects like V8, WebRTC & Skia.
  - [Schedule](https://chromiumdash.appspot.com/schedule) - Review upcoming Chromium release schedule.
  - [Branches](https://chromiumdash.appspot.com/branches) - Look up which branch corresponds to which milestone.
  - [Releases](https://chromiumdash.appspot.com/releases) - See what version of Chromium is shipping to each release channel and look up changes between each version.
  - [Commits](https://chromiumdash.appspot.com/commits) - See and search for commits to the Chromium source tree by commit SHA or committer username.
- [Discussion Groups](https://www.chromium.org/developers/discussion-groups) - Subscribe to the following groups to get project updates and discuss the Chromium projects, and to get help in developing for Chromium-based browsers.
- [Chromium Slack](https://www.chromium.org/developers/slack) - a virtual meeting place where Chromium ecosystem developers can foster community and coordinate work.

## Social Links

- [Blog](https://blog.chromium.org) - News and developments from Chromium.
- [@ChromiumDev](https://twitter.com/ChromiumDev) - Twitter account containing news & guidance for developers from the Google Chrome Developer Relations team.
- [@googlechrome](https://twitter.com/googlechrome) - Official Twitter account for the Google Chrome browser.
