/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.ObjectParameterType;
import java.nio.Buffer;
import java.util.EnumSet;
import jnr.ffi.provider.jffi.PointerParameterStrategy;

final class DirectBufferParameterStrategy
extends PointerParameterStrategy {
    private final int shift;
    private static final DirectBufferParameterStrategy[] directBufferStrategies;

    public DirectBufferParameterStrategy(ObjectParameterType.ComponentType componentType) {
        super(DIRECT, ObjectParameterType.create((ObjectParameterType.ObjectType)ObjectParameterType.ObjectType.BUFFER, (ObjectParameterType.ComponentType)componentType));
        this.shift = DirectBufferParameterStrategy.calculateShift(componentType);
    }

    public long address(Object o) {
        Buffer buffer = (Buffer)o;
        return MemoryIO.getInstance().getDirectBufferAddress(buffer) + (long)(buffer.position() << this.shift);
    }

    public Object object(Object o) {
        return o;
    }

    public int offset(Object o) {
        return ((Buffer)o).position() << this.shift;
    }

    public int length(Object o) {
        return ((Buffer)o).remaining() << this.shift;
    }

    private static int calculateShift(ObjectParameterType.ComponentType componentType) {
        switch (componentType) {
            case BYTE: {
                return 0;
            }
            case SHORT: 
            case CHAR: {
                return 1;
            }
            case INT: 
            case BOOLEAN: 
            case FLOAT: {
                return 2;
            }
            case LONG: 
            case DOUBLE: {
                return 3;
            }
        }
        throw new IllegalArgumentException("unsupported component type: " + componentType);
    }

    static PointerParameterStrategy get(ObjectParameterType.ComponentType componentType) {
        return directBufferStrategies[componentType.ordinal()];
    }

    static {
        EnumSet<ObjectParameterType.ComponentType> componentTypes = EnumSet.allOf(ObjectParameterType.ComponentType.class);
        directBufferStrategies = new DirectBufferParameterStrategy[componentTypes.size()];
        for (ObjectParameterType.ComponentType componentType : componentTypes) {
            DirectBufferParameterStrategy.directBufferStrategies[componentType.ordinal()] = new DirectBufferParameterStrategy(componentType);
        }
    }
}

