<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model app\models\Proxy */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="proxy-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'ip')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'port')->textInput() ?>

    <?= $form->field($model, 'username')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'password')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'active')->checkbox() ?>
    <?= $form->field($model, 'default_for_accounts')->checkbox() ?>
    <?= $form->field($model, 'default_for_tags')->checkbox() ?>

    <?= $form->field($model, 'tagString')->widget(\kartik\select2\Select2::class, [
        'options' => [
            'multiple' => true,
            'placeholder' => 'Select tags...',
        ],
        'pluginOptions' => [
            'tags' => true,
        ],
        'data' => $selectData,
    ]) ?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
