/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.Serializable;
import sandbox.java.util.AbstractQueue;
import sandbox.java.util.Collection;
import sandbox.java.util.Iterator;
import sandbox.java.util.NoSuchElementException;
import sandbox.java.util.Spliterator;
import sandbox.java.util.Spliterators;
import sandbox.java.util.concurrent.ArrayBlockingQueue;
import sandbox.java.util.concurrent.BlockingQueue;
import sandbox.java.util.concurrent.TimeUnit;
import sandbox.java.util.concurrent.locks.Condition;
import sandbox.java.util.concurrent.locks.ReentrantLock;

public class ArrayBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    private static final long serialVersionUID = -817911632652898426L;
    final Object[] items;
    int takeIndex;
    int putIndex;
    int count;
    final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;
    transient Itrs itrs;

    final int dec(int n) {
        int n2;
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            n2 = this.items.length;
            RuntimeCostAccounter.recordJump();
        } else {
            n2 = n;
        }
        return n2 - 1;
    }

    final E itemAt(int n) {
        return (E)this.items[n];
    }

    private static void checkNotNull(Object object) {
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
    }

    private void enqueue(E e) {
        Object[] objectArray = this.items;
        objectArray[this.putIndex] = e;
        int n = objectArray.length;
        RuntimeCostAccounter.recordJump();
        if (++this.putIndex == n) {
            this.putIndex = 0;
        }
        ++this.count;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
        this.notEmpty.signal();
    }

    private E dequeue() {
        Object[] objectArray = this.items;
        Object object = objectArray[this.takeIndex];
        objectArray[this.takeIndex] = null;
        int n = objectArray.length;
        RuntimeCostAccounter.recordJump();
        if (++this.takeIndex == n) {
            this.takeIndex = 0;
        }
        --this.count;
        RuntimeCostAccounter.recordJump();
        if (this.itrs != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itrs.elementDequeued:()V");
            this.itrs.elementDequeued();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
        this.notFull.signal();
        return (E)object;
    }

    void removeAt(int n) {
        Object[] objectArray = this.items;
        RuntimeCostAccounter.recordJump();
        if (n == this.takeIndex) {
            objectArray[this.takeIndex] = null;
            int n2 = objectArray.length;
            RuntimeCostAccounter.recordJump();
            if (++this.takeIndex == n2) {
                this.takeIndex = 0;
            }
            --this.count;
            RuntimeCostAccounter.recordJump();
            if (this.itrs != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itrs.elementDequeued:()V");
                this.itrs.elementDequeued();
                RuntimeCostAccounter.recordJump();
            }
        } else {
            int n3 = this.putIndex;
            int n4 = n;
            while (true) {
                int n5 = n4 + 1;
                int n6 = objectArray.length;
                RuntimeCostAccounter.recordJump();
                if (n5 == n6) {
                    n5 = 0;
                }
                RuntimeCostAccounter.recordJump();
                if (n5 == n3) break;
                objectArray[n4] = objectArray[n5];
                n4 = n5;
                RuntimeCostAccounter.recordJump();
                RuntimeCostAccounter.recordJump();
            }
            objectArray[n4] = null;
            this.putIndex = n4;
            RuntimeCostAccounter.recordJump();
            --this.count;
            RuntimeCostAccounter.recordJump();
            if (this.itrs != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itrs.removedAt:(I)V");
                this.itrs.removedAt(n);
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
        this.notFull.signal();
    }

    public ArrayBlockingQueue(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue.<init>:(IZ)V");
        this(n, false);
    }

    public ArrayBlockingQueue(int n, boolean bl) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractQueue.<init>:()V");
        this.itrs = null;
        RuntimeCostAccounter.recordJump();
        if (n <= 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        int n2 = n;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
        this.items = new Object[n2];
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/ReentrantLock");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.<init>:(Z)V");
        this.lock = new ReentrantLock(bl);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.newCondition:()Ljava/util/concurrent/locks/Condition;");
        this.notEmpty = this.lock.newCondition();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.newCondition:()Ljava/util/concurrent/locks/Condition;");
        this.notFull = this.lock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayBlockingQueue(int n, boolean bl, Collection<? extends E> collection) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue.<init>:(IZ)V");
        this(n, bl);
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            int n2;
            int n3 = 0;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
                Iterator<E> iterator = collection.iterator();
                while (true) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                    boolean bl2 = iterator.hasNext();
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                        E e = iterator.next();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue.checkNotNull:(Ljava/lang/Object;)V");
                        ArrayBlockingQueue.checkNotNull(e);
                        this.items[n3++] = e;
                        RuntimeCostAccounter.recordJump();
                        continue;
                    }
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordJump();
            this.count = n3;
            RuntimeCostAccounter.recordJump();
            if (n3 == n) {
                n2 = 0;
                RuntimeCostAccounter.recordJump();
            } else {
                n2 = n3;
            }
            this.putIndex = n2;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
    }

    @Override
    public boolean add(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractQueue.add:(Ljava/lang/Object;)Z");
        return super.add(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        ReentrantLock reentrantLock;
        block3: {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue.checkNotNull:(Ljava/lang/Object;)V");
            ArrayBlockingQueue.checkNotNull(e);
            reentrantLock = this.lock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            try {
                int n = this.items.length;
                RuntimeCostAccounter.recordJump();
                if (this.count != n) break block3;
                bl = false;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            return bl;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue.enqueue:(Ljava/lang/Object;)V");
        this.enqueue(e);
        boolean bl = true;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return bl;
    }

    @Override
    public void put(E e) throws InterruptedException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue.checkNotNull:(Ljava/lang/Object;)V");
        ArrayBlockingQueue.checkNotNull(e);
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lockInterruptibly:()V");
        reentrantLock.lockInterruptibly();
        try {
            while (true) {
                int n = this.items.length;
                RuntimeCostAccounter.recordJump();
                if (this.count != n) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.await:()V");
                this.notFull.await();
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue.enqueue:(Ljava/lang/Object;)V");
            this.enqueue(e);
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean offer(E var1_1, long var2_2, TimeUnit var4_3) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public E poll() {
        E e;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            E e2;
            RuntimeCostAccounter.recordJump();
            if (this.count == 0) {
                e2 = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue.dequeue:()Ljava/lang/Object;");
                e2 = this.dequeue();
            }
            e = e2;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return e;
    }

    @Override
    public E take() throws InterruptedException {
        E e;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lockInterruptibly:()V");
        reentrantLock.lockInterruptibly();
        try {
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (this.count != 0) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.await:()V");
                this.notEmpty.await();
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue.dequeue:()Ljava/lang/Object;");
            e = this.dequeue();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return e;
    }

    /*
     * Exception decompiling
     */
    @Override
    public E poll(long var1_1, TimeUnit var3_2) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public E peek() {
        E e;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue.itemAt:(I)Ljava/lang/Object;");
            e = this.itemAt(this.takeIndex);
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return e;
    }

    @Override
    public int size() {
        int n;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            n = this.count;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return n;
    }

    @Override
    public int remainingCapacity() {
        int n;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            n = this.items.length - this.count;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean remove(Object var1_1) {
        RuntimeCostAccounter.recordJump();
        if (var1_1 == null) {
            return false;
        }
        var2_2 = this.items;
        var3_3 = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        var3_3.lock();
        try {
            RuntimeCostAccounter.recordJump();
            if (this.count <= 0) ** GOTO lbl38
            var4_4 = this.putIndex;
            var5_5 = this.takeIndex;
            while (true) {
                v0 = var2_2[var5_5];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                v1 = var1_1.equals(v0);
                RuntimeCostAccounter.recordJump();
                if (v1) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue.removeAt:(I)V");
                    this.removeAt(var5_5);
                    var6_6 = true;
                }
                ** GOTO lbl-1000
                break;
            }
        }
        catch (Throwable var7_7) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            var3_3.unlock();
            RuntimeCostAccounter.recordThrow();
            throw var7_7;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        var3_3.unlock();
        return var6_6;
lbl-1000:
        // 1 sources

        {
            v2 = var2_2.length;
            RuntimeCostAccounter.recordJump();
            if (++var5_5 == v2) {
                var5_5 = 0;
            }
            RuntimeCostAccounter.recordJump();
            if (var5_5 != var4_4) ** continue;
lbl38:
            // 2 sources

            var4_4 = 0;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        var3_3.unlock();
        return (boolean)var4_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean contains(Object var1_1) {
        RuntimeCostAccounter.recordJump();
        if (var1_1 == null) {
            return false;
        }
        var2_2 = this.items;
        var3_3 = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        var3_3.lock();
        try {
            RuntimeCostAccounter.recordJump();
            if (this.count <= 0) ** GOTO lbl36
            var4_4 = this.putIndex;
            var5_5 = this.takeIndex;
            while (true) {
                v0 = var2_2[var5_5];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                v1 = var1_1.equals(v0);
                RuntimeCostAccounter.recordJump();
                if (v1) {
                    var6_6 = true;
                }
                ** GOTO lbl-1000
                break;
            }
        }
        catch (Throwable var7_7) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            var3_3.unlock();
            RuntimeCostAccounter.recordThrow();
            throw var7_7;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        var3_3.unlock();
        return var6_6;
lbl-1000:
        // 1 sources

        {
            v2 = var2_2.length;
            RuntimeCostAccounter.recordJump();
            if (++var5_5 == v2) {
                var5_5 = 0;
            }
            RuntimeCostAccounter.recordJump();
            if (var5_5 != var4_4) ** continue;
lbl36:
            // 2 sources

            var4_4 = 0;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        var3_3.unlock();
        return (boolean)var4_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object[] objectArray;
        ReentrantLock reentrantLock;
        block3: {
            reentrantLock = this.lock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            try {
                int n;
                int n2 = n = this.count;
                RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
                objectArray = new Object[n2];
                int n3 = this.items.length - this.takeIndex;
                RuntimeCostAccounter.recordJump();
                if (n <= n3) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                    System.arraycopy(this.items, this.takeIndex, objectArray, 0, n);
                    RuntimeCostAccounter.recordJump();
                    break block3;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                System.arraycopy(this.items, this.takeIndex, objectArray, 0, n3);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                System.arraycopy(this.items, 0, objectArray, n3, n - n3);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] objectArray) {
        Object[] objectArray2 = this.items;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            int n = this.count;
            int n2 = objectArray.length;
            RuntimeCostAccounter.recordJump();
            if (n2 < n) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                Class<?> clazz = objectArray.getClass();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getComponentType:()Ljava/lang/Class;");
                Class<?> clazz2 = clazz.getComponentType();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/reflect/Array.newInstance:(Ljava/lang/Class;I)Ljava/lang/Object;");
                objectArray = (Object[])Array.newInstance(clazz2, n);
            }
            int n3 = objectArray2.length - this.takeIndex;
            RuntimeCostAccounter.recordJump();
            if (n <= n3) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                System.arraycopy(objectArray2, this.takeIndex, objectArray, 0, n);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                System.arraycopy(objectArray2, this.takeIndex, objectArray, 0, n3);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                System.arraycopy(objectArray2, 0, objectArray, n3, n - n3);
            }
            RuntimeCostAccounter.recordJump();
            if (n2 > n) {
                objectArray[n] = null;
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
        return objectArray;
    }

    @Override
    public String toString() {
        String string;
        int n;
        StringBuilder stringBuilder;
        Object[] objectArray;
        int n2;
        ReentrantLock reentrantLock;
        block8: {
            reentrantLock = this.lock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            n2 = this.count;
            RuntimeCostAccounter.recordJump();
            if (n2 != 0) break block8;
            String string2 = "[]";
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            return string2;
        }
        try {
            objectArray = this.items;
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            stringBuilder.append('[');
            n = this.takeIndex;
            while (true) {
                Object object;
                Object object2 = objectArray[n];
                RuntimeCostAccounter.recordJump();
                if (object2 == this) {
                    object = "(this Collection)";
                    RuntimeCostAccounter.recordJump();
                } else {
                    object = object2;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                stringBuilder.append(object);
                RuntimeCostAccounter.recordJump();
                if (--n2 != 0) break block9;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append(']');
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                string = stringBuilder2.toString();
                break;
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        {
            block9: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                return string;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder.append(',');
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            stringBuilder3.append(' ');
            int n3 = objectArray.length;
            RuntimeCostAccounter.recordJump();
            if (++n == n3) {
                n = 0;
            }
            RuntimeCostAccounter.recordJump();
            continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object[] objectArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            int n = this.count;
            RuntimeCostAccounter.recordJump();
            if (n > 0) {
                int n2 = this.putIndex;
                int n3 = this.takeIndex;
                do {
                    objectArray[n3] = null;
                    int n4 = objectArray.length;
                    RuntimeCostAccounter.recordJump();
                    if (++n3 == n4) {
                        n3 = 0;
                    }
                    RuntimeCostAccounter.recordJump();
                } while (n3 != n2);
                this.takeIndex = n2;
                this.count = 0;
                RuntimeCostAccounter.recordJump();
                if (this.itrs != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itrs.queueIsEmpty:()V");
                    this.itrs.queueIsEmpty();
                }
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n <= 0) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.hasWaiters:(Ljava/util/concurrent/locks/Condition;)Z");
                    boolean bl = reentrantLock.hasWaiters(this.notFull);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
                    this.notFull.signal();
                    --n;
                    RuntimeCostAccounter.recordJump();
                }
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue.drainTo:(Ljava/util/Collection;I)I");
        return this.drainTo(collection, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        int n2;
        int n3;
        int n4;
        ReentrantLock reentrantLock;
        block20: {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue.checkNotNull:(Ljava/lang/Object;)V");
            ArrayBlockingQueue.checkNotNull(collection);
            RuntimeCostAccounter.recordJump();
            if (collection == this) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordJump();
            if (n <= 0) {
                return 0;
            }
            Object[] objectArray = this.items;
            reentrantLock = this.lock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
            int n5 = Math.min(n, this.count);
            n4 = this.takeIndex;
            n3 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n3 >= n5) break;
                Object object = objectArray[n4];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.add:(Ljava/lang/Object;)Z");
                collection.add(object);
                objectArray[n4] = null;
                int n6 = objectArray.length;
                RuntimeCostAccounter.recordJump();
                if (++n4 == n6) {
                    n4 = 0;
                }
                ++n3;
                RuntimeCostAccounter.recordJump();
            }
            n2 = n5;
            RuntimeCostAccounter.recordJump();
            if (n3 <= 0) break block20;
            this.count -= n3;
            this.takeIndex = n4;
            RuntimeCostAccounter.recordJump();
            if (this.itrs != null) {
                RuntimeCostAccounter.recordJump();
                if (this.count == 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itrs.queueIsEmpty:()V");
                    this.itrs.queueIsEmpty();
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (n3 > n4) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itrs.takeIndexWrapped:()V");
                        this.itrs.takeIndexWrapped();
                    }
                }
            }
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n3 <= 0) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.hasWaiters:(Ljava/util/concurrent/locks/Condition;)Z");
                boolean bl = reentrantLock.hasWaiters(this.notFull);
                RuntimeCostAccounter.recordJump();
                if (!bl) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
                this.notFull.signal();
                --n3;
                RuntimeCostAccounter.recordJump();
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return n2;
        {
            catch (Throwable throwable) {
                try {
                    RuntimeCostAccounter.recordJump();
                    if (n3 > 0) {
                        this.count -= n3;
                        this.takeIndex = n4;
                        RuntimeCostAccounter.recordJump();
                        if (this.itrs != null) {
                            RuntimeCostAccounter.recordJump();
                            if (this.count == 0) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itrs.queueIsEmpty:()V");
                                this.itrs.queueIsEmpty();
                                RuntimeCostAccounter.recordJump();
                            } else {
                                RuntimeCostAccounter.recordJump();
                                if (n3 > n4) {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itrs.takeIndexWrapped:()V");
                                    this.itrs.takeIndexWrapped();
                                }
                            }
                        }
                        while (true) {
                            RuntimeCostAccounter.recordJump();
                            if (n3 <= 0) break;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.hasWaiters:(Ljava/util/concurrent/locks/Condition;)Z");
                            boolean bl = reentrantLock.hasWaiters(this.notFull);
                            RuntimeCostAccounter.recordJump();
                            if (!bl) break;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
                            this.notFull.signal();
                            --n3;
                            RuntimeCostAccounter.recordJump();
                        }
                    }
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                    reentrantLock.unlock();
                    RuntimeCostAccounter.recordThrow();
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public Iterator<E> iterator() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ArrayBlockingQueue$Itr");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itr.<init>:(Ljava/util/concurrent/ArrayBlockingQueue;)V");
        return new Itr();
    }

    @Override
    public Spliterator<E> spliterator() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.spliterator:(Ljava/util/Collection;I)Ljava/util/Spliterator;");
        return Spliterators.spliterator(this, 4368);
    }

    private class Itr
    implements Iterator<E> {
        private int cursor;
        private E nextItem;
        private int nextIndex;
        private E lastItem;
        private int lastRet;
        private int prevTakeIndex;
        private int prevCycles;
        private static final int NONE = -1;
        private static final int REMOVED = -2;
        private static final int DETACHED = -3;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Itr() {
            ReentrantLock reentrantLock;
            block5: {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                this.lastRet = -1;
                reentrantLock = ArrayBlockingQueue.this.lock;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
                reentrantLock.lock();
                try {
                    int n;
                    int n2 = ArrayBlockingQueue.this.count;
                    RuntimeCostAccounter.recordJump();
                    if (n2 == 0) {
                        this.cursor = -1;
                        this.nextIndex = -1;
                        this.prevTakeIndex = -3;
                        RuntimeCostAccounter.recordJump();
                        break block5;
                    }
                    this.prevTakeIndex = n = ArrayBlockingQueue.this.takeIndex;
                    this.nextIndex = n;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue.itemAt:(I)Ljava/lang/Object;");
                    this.nextItem = ArrayBlockingQueue.this.itemAt(this.nextIndex);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itr.incCursor:(I)I");
                    this.cursor = this.incCursor(n);
                    Itrs itrs = ArrayBlockingQueue.this.itrs;
                    RuntimeCostAccounter.recordJump();
                    if (itrs == null) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ArrayBlockingQueue$Itrs");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itrs.<init>:(Ljava/util/concurrent/ArrayBlockingQueue;Ljava/util/concurrent/ArrayBlockingQueue$Itr;)V");
                        ArrayBlockingQueue.this.itrs = new Itrs(this);
                        RuntimeCostAccounter.recordJump();
                    } else {
                        Itrs itrs2 = ArrayBlockingQueue.this.itrs;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itrs.register:(Ljava/util/concurrent/ArrayBlockingQueue$Itr;)V");
                        itrs2.register(this);
                        Itrs itrs3 = ArrayBlockingQueue.this.itrs;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itrs.doSomeSweeping:(Z)V");
                        itrs3.doSomeSweeping(false);
                    }
                    this.prevCycles = ArrayBlockingQueue.this.itrs.cycles;
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                    reentrantLock.unlock();
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordJump();
        }

        boolean isDetached() {
            boolean bl;
            RuntimeCostAccounter.recordJump();
            if (this.prevTakeIndex < 0) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        private int incCursor(int n) {
            int n2 = ArrayBlockingQueue.this.items.length;
            RuntimeCostAccounter.recordJump();
            if (++n == n2) {
                n = 0;
            }
            int n3 = ArrayBlockingQueue.this.putIndex;
            RuntimeCostAccounter.recordJump();
            if (n == n3) {
                n = -1;
            }
            return n;
        }

        private boolean invalidated(int n, int n2, long l, int n3) {
            boolean bl;
            long l2;
            RuntimeCostAccounter.recordJump();
            if (n < 0) {
                return false;
            }
            int n4 = n - n2;
            RuntimeCostAccounter.recordJump();
            if (n4 < 0) {
                n4 += n3;
            }
            long l3 = (l2 = l - (long)n4) == 0L ? 0 : (l2 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l3 > 0) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void incorporateDequeues() {
            int n = ArrayBlockingQueue.this.itrs.cycles;
            int n2 = ArrayBlockingQueue.this.takeIndex;
            int n3 = this.prevCycles;
            int n4 = this.prevTakeIndex;
            RuntimeCostAccounter.recordJump();
            if (n == n3) {
                RuntimeCostAccounter.recordJump();
                if (n2 == n4) return;
            }
            int n5 = ArrayBlockingQueue.this.items.length;
            long l = (n - n3) * n5 + (n2 - n4);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itr.invalidated:(IIJI)Z");
            boolean bl = this.invalidated(this.lastRet, n4, l, n5);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                this.lastRet = -2;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itr.invalidated:(IIJI)Z");
            boolean bl2 = this.invalidated(this.nextIndex, n4, l, n5);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                this.nextIndex = -2;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itr.invalidated:(IIJI)Z");
            boolean bl3 = this.invalidated(this.cursor, n4, l, n5);
            RuntimeCostAccounter.recordJump();
            if (bl3) {
                this.cursor = n2;
            }
            RuntimeCostAccounter.recordJump();
            if (this.cursor < 0) {
                RuntimeCostAccounter.recordJump();
                if (this.nextIndex < 0) {
                    RuntimeCostAccounter.recordJump();
                    if (this.lastRet < 0) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itr.detach:()V");
                        this.detach();
                        RuntimeCostAccounter.recordJump();
                        return;
                    }
                }
            }
            this.prevCycles = n;
            this.prevTakeIndex = n2;
        }

        private void detach() {
            RuntimeCostAccounter.recordJump();
            if (this.prevTakeIndex >= 0) {
                this.prevTakeIndex = -3;
                Itrs itrs = ArrayBlockingQueue.this.itrs;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itrs.doSomeSweeping:(Z)V");
                itrs.doSomeSweeping(true);
            }
        }

        @Override
        public boolean hasNext() {
            RuntimeCostAccounter.recordJump();
            if (this.nextItem != null) {
                return true;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itr.noNext:()V");
            this.noNext();
            return false;
        }

        private void noNext() {
            ReentrantLock reentrantLock;
            block3: {
                reentrantLock = ArrayBlockingQueue.this.lock;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
                reentrantLock.lock();
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itr.isDetached:()Z");
                    boolean bl = this.isDetached();
                    RuntimeCostAccounter.recordJump();
                    if (bl) break block3;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itr.incorporateDequeues:()V");
                    this.incorporateDequeues();
                    RuntimeCostAccounter.recordJump();
                    if (this.lastRet >= 0) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue.itemAt:(I)Ljava/lang/Object;");
                        this.lastItem = ArrayBlockingQueue.this.itemAt(this.lastRet);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itr.detach:()V");
                        this.detach();
                    }
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                    reentrantLock.unlock();
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordJump();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            ReentrantLock reentrantLock;
            Object e;
            block5: {
                e = this.nextItem;
                RuntimeCostAccounter.recordJump();
                if (e == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                    NoSuchElementException noSuchElementException = new NoSuchElementException();
                    RuntimeCostAccounter.recordThrow();
                    throw noSuchElementException;
                }
                reentrantLock = ArrayBlockingQueue.this.lock;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
                reentrantLock.lock();
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itr.isDetached:()Z");
                    boolean bl = this.isDetached();
                    RuntimeCostAccounter.recordJump();
                    if (!bl) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itr.incorporateDequeues:()V");
                        this.incorporateDequeues();
                    }
                    this.lastRet = this.nextIndex;
                    int n = this.cursor;
                    RuntimeCostAccounter.recordJump();
                    if (n >= 0) {
                        this.nextIndex = n;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue.itemAt:(I)Ljava/lang/Object;");
                        this.nextItem = ArrayBlockingQueue.this.itemAt(this.nextIndex);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itr.incCursor:(I)I");
                        this.cursor = this.incCursor(n);
                        RuntimeCostAccounter.recordJump();
                        break block5;
                    }
                    this.nextIndex = -1;
                    this.nextItem = null;
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                    reentrantLock.unlock();
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordJump();
            return e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            ReentrantLock reentrantLock;
            block10: {
                reentrantLock = ArrayBlockingQueue.this.lock;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
                reentrantLock.lock();
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itr.isDetached:()Z");
                    boolean bl = this.isDetached();
                    RuntimeCostAccounter.recordJump();
                    if (!bl) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itr.incorporateDequeues:()V");
                        this.incorporateDequeues();
                    }
                    int n = this.lastRet;
                    this.lastRet = -1;
                    RuntimeCostAccounter.recordJump();
                    if (n >= 0) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itr.isDetached:()Z");
                        boolean bl2 = this.isDetached();
                        RuntimeCostAccounter.recordJump();
                        if (!bl2) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue.removeAt:(I)V");
                            ArrayBlockingQueue.this.removeAt(n);
                            RuntimeCostAccounter.recordJump();
                        } else {
                            Object e = this.lastItem;
                            this.lastItem = null;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue.itemAt:(I)Ljava/lang/Object;");
                            Object e2 = ArrayBlockingQueue.this.itemAt(n);
                            RuntimeCostAccounter.recordJump();
                            if (e2 == e) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue.removeAt:(I)V");
                                ArrayBlockingQueue.this.removeAt(n);
                            }
                            RuntimeCostAccounter.recordJump();
                        }
                    } else {
                        RuntimeCostAccounter.recordJump();
                        if (n == -1) {
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
                            IllegalStateException illegalStateException = new IllegalStateException();
                            RuntimeCostAccounter.recordThrow();
                            throw illegalStateException;
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    if (this.cursor >= 0) break block10;
                    RuntimeCostAccounter.recordJump();
                    if (this.nextIndex < 0) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itr.detach:()V");
                        this.detach();
                    }
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                    reentrantLock.unlock();
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordJump();
        }

        void shutdown() {
            this.cursor = -1;
            RuntimeCostAccounter.recordJump();
            if (this.nextIndex >= 0) {
                this.nextIndex = -2;
            }
            RuntimeCostAccounter.recordJump();
            if (this.lastRet >= 0) {
                this.lastRet = -2;
                this.lastItem = null;
            }
            this.prevTakeIndex = -3;
        }

        private int distance(int n, int n2, int n3) {
            int n4 = n - n2;
            RuntimeCostAccounter.recordJump();
            if (n4 < 0) {
                n4 += n3;
            }
            return n4;
        }

        boolean removedAt(int n) {
            int n2;
            int n3;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itr.isDetached:()Z");
            boolean bl = this.isDetached();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return true;
            }
            int n4 = ArrayBlockingQueue.this.itrs.cycles;
            int n5 = ArrayBlockingQueue.this.takeIndex;
            int n6 = this.prevCycles;
            int n7 = this.prevTakeIndex;
            int n8 = ArrayBlockingQueue.this.items.length;
            int n9 = n4 - n6;
            RuntimeCostAccounter.recordJump();
            if (n < n5) {
                ++n9;
            }
            int n10 = n9 * n8 + (n - n7);
            int n11 = this.cursor;
            RuntimeCostAccounter.recordJump();
            if (n11 >= 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itr.distance:(III)I");
                n3 = this.distance(n11, n7, n8);
                RuntimeCostAccounter.recordJump();
                if (n3 == n10) {
                    int n12 = ArrayBlockingQueue.this.putIndex;
                    RuntimeCostAccounter.recordJump();
                    if (n11 == n12) {
                        n11 = -1;
                        this.cursor = -1;
                        RuntimeCostAccounter.recordJump();
                    }
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (n3 > n10) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue.dec:(I)I");
                        this.cursor = n11 = ArrayBlockingQueue.this.dec(n11);
                    }
                }
            }
            n3 = this.lastRet;
            RuntimeCostAccounter.recordJump();
            if (n3 >= 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itr.distance:(III)I");
                n2 = this.distance(n3, n7, n8);
                RuntimeCostAccounter.recordJump();
                if (n2 == n10) {
                    n3 = -2;
                    this.lastRet = -2;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (n2 > n10) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue.dec:(I)I");
                        this.lastRet = n3 = ArrayBlockingQueue.this.dec(n3);
                    }
                }
            }
            n2 = this.nextIndex;
            RuntimeCostAccounter.recordJump();
            if (n2 >= 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itr.distance:(III)I");
                int n13 = this.distance(n2, n7, n8);
                RuntimeCostAccounter.recordJump();
                if (n13 == n10) {
                    n2 = -2;
                    this.nextIndex = -2;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (n13 > n10) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue.dec:(I)I");
                        this.nextIndex = n2 = ArrayBlockingQueue.this.dec(n2);
                    }
                }
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (n11 < 0) {
                    RuntimeCostAccounter.recordJump();
                    if (n2 < 0) {
                        RuntimeCostAccounter.recordJump();
                        if (n3 < 0) {
                            this.prevTakeIndex = -3;
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        boolean takeIndexWrapped() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itr.isDetached:()Z");
            boolean bl = this.isDetached();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return true;
            }
            int n = ArrayBlockingQueue.this.itrs.cycles - this.prevCycles;
            RuntimeCostAccounter.recordJump();
            if (n > 1) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itr.shutdown:()V");
                this.shutdown();
                return true;
            }
            return false;
        }
    }

    class Itrs {
        int cycles;
        private sandbox.java.util.concurrent.ArrayBlockingQueue$Itrs.Node head;
        private sandbox.java.util.concurrent.ArrayBlockingQueue$Itrs.Node sweeper;
        private static final int SHORT_SWEEP_PROBES = 4;
        private static final int LONG_SWEEP_PROBES = 16;

        Itrs(Itr itr) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.cycles = 0;
            this.sweeper = null;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itrs.register:(Ljava/util/concurrent/ArrayBlockingQueue$Itr;)V");
            this.register(itr);
        }

        /*
         * Unable to fully structure code
         */
        void doSomeSweeping(boolean var1_1) {
            RuntimeCostAccounter.recordJump();
            if (var1_1) {
                v0 = 16;
                RuntimeCostAccounter.recordJump();
            } else {
                v0 = 4;
            }
            var2_2 = v0;
            var3_3 = this.sweeper;
            RuntimeCostAccounter.recordJump();
            if (var3_3 == null) {
                var4_4 = null;
                var5_5 = this.head;
                var6_6 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                var4_4 = var3_3;
                var5_5 = var4_4.next;
                var6_6 = false;
            }
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (var2_2 <= 0) break;
                RuntimeCostAccounter.recordJump();
                if (var5_5 == null) {
                    RuntimeCostAccounter.recordJump();
                    if (var6_6) {
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    var4_4 = null;
                    var5_5 = this.head;
                    var6_6 = true;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itrs$Node.get:()Ljava/lang/Object;");
                var7_7 = (Itr)var5_5.get();
                var8_8 = var5_5.next;
                RuntimeCostAccounter.recordJump();
                if (var7_7 == null) ** GOTO lbl-1000
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itr.isDetached:()Z");
                v1 = var7_7.isDetached();
                RuntimeCostAccounter.recordJump();
                if (v1) lbl-1000:
                // 2 sources

                {
                    var2_2 = 16;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itrs$Node.clear:()V");
                    var5_5.clear();
                    var5_5.next = null;
                    RuntimeCostAccounter.recordJump();
                    if (var4_4 == null) {
                        this.head = var8_8;
                        RuntimeCostAccounter.recordJump();
                        if (var8_8 == null) {
                            ArrayBlockingQueue.this.itrs = null;
                            return;
                        }
                    } else {
                        var4_4.next = var8_8;
                        RuntimeCostAccounter.recordJump();
                    }
                } else {
                    var4_4 = var5_5;
                }
                var5_5 = var8_8;
                --var2_2;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
            if (var5_5 == null) {
                v2 = null;
                RuntimeCostAccounter.recordJump();
            } else {
                v2 = var4_4;
            }
            this.sweeper = v2;
        }

        void register(Itr itr) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ArrayBlockingQueue$Itrs$Node");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itrs$Node.<init>:(Ljava/util/concurrent/ArrayBlockingQueue$Itrs;Ljava/util/concurrent/ArrayBlockingQueue$Itr;Ljava/util/concurrent/ArrayBlockingQueue$Itrs$Node;)V");
            this.head = new Node(this, itr, (Node)this.head);
        }

        /*
         * Unable to fully structure code
         */
        void takeIndexWrapped() {
            ++this.cycles;
            var1_1 = null;
            var2_2 = this.head;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (var2_2 == null) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itrs$Node.get:()Ljava/lang/Object;");
                var3_3 = (Itr)var2_2.get();
                var4_4 = var2_2.next;
                RuntimeCostAccounter.recordJump();
                if (var3_3 == null) ** GOTO lbl-1000
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itr.takeIndexWrapped:()Z");
                v0 = var3_3.takeIndexWrapped();
                RuntimeCostAccounter.recordJump();
                if (v0) lbl-1000:
                // 2 sources

                {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itrs$Node.clear:()V");
                    var2_2.clear();
                    var2_2.next = null;
                    RuntimeCostAccounter.recordJump();
                    if (var1_1 == null) {
                        this.head = var4_4;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        var1_1.next = var4_4;
                        RuntimeCostAccounter.recordJump();
                    }
                } else {
                    var1_1 = var2_2;
                }
                var2_2 = var4_4;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
            if (this.head == null) {
                ArrayBlockingQueue.this.itrs = null;
            }
        }

        /*
         * Unable to fully structure code
         */
        void removedAt(int var1_1) {
            var2_2 = null;
            var3_3 = this.head;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (var3_3 == null) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itrs$Node.get:()Ljava/lang/Object;");
                var4_4 = (Itr)var3_3.get();
                var5_5 = var3_3.next;
                RuntimeCostAccounter.recordJump();
                if (var4_4 == null) ** GOTO lbl-1000
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itr.removedAt:(I)Z");
                v0 = var4_4.removedAt(var1_1);
                RuntimeCostAccounter.recordJump();
                if (v0) lbl-1000:
                // 2 sources

                {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itrs$Node.clear:()V");
                    var3_3.clear();
                    var3_3.next = null;
                    RuntimeCostAccounter.recordJump();
                    if (var2_2 == null) {
                        this.head = var5_5;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        var2_2.next = var5_5;
                        RuntimeCostAccounter.recordJump();
                    }
                } else {
                    var2_2 = var3_3;
                }
                var3_3 = var5_5;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
            if (this.head == null) {
                ArrayBlockingQueue.this.itrs = null;
            }
        }

        void queueIsEmpty() {
            sandbox.java.util.concurrent.ArrayBlockingQueue$Itrs.Node node = this.head;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (node == null) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itrs$Node.get:()Ljava/lang/Object;");
                Itr itr = (Itr)node.get();
                RuntimeCostAccounter.recordJump();
                if (itr != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itrs$Node.clear:()V");
                    node.clear();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itr.shutdown:()V");
                    itr.shutdown();
                }
                node = node.next;
                RuntimeCostAccounter.recordJump();
            }
            this.head = null;
            ArrayBlockingQueue.this.itrs = null;
        }

        void elementDequeued() {
            int n = ArrayBlockingQueue.this.count;
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itrs.queueIsEmpty:()V");
                this.queueIsEmpty();
                RuntimeCostAccounter.recordJump();
            } else {
                int n2 = ArrayBlockingQueue.this.takeIndex;
                RuntimeCostAccounter.recordJump();
                if (n2 == 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ArrayBlockingQueue$Itrs.takeIndexWrapped:()V");
                    this.takeIndexWrapped();
                }
            }
        }

        private static class Node
        extends WeakReference<Itr> {
            sandbox.java.util.concurrent.ArrayBlockingQueue$Itrs.Node next;
            final /* synthetic */ Itrs this$1;

            Node(Itr itr, sandbox.java.util.concurrent.ArrayBlockingQueue$Itrs.Node node) {
                this.this$1 = var1_1;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/WeakReference.<init>:(Ljava/lang/Object;)V");
                super(itr);
                this.next = node;
            }
        }
    }
}

