/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.io;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.FilterInputStream;
import sandbox.java.io.IOException;
import sandbox.java.io.InputStream;
import sandbox.java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class BufferedInputStream
extends FilterInputStream {
    private static int DEFAULT_BUFFER_SIZE = 8192;
    private static int MAX_BUFFER_SIZE = 0x7FFFFFF7;
    protected volatile byte[] buf;
    private static final AtomicReferenceFieldUpdater<BufferedInputStream, byte[]> bufUpdater;
    protected int count;
    protected int pos;
    protected int markpos;
    protected int marklimit;

    private InputStream getInIfOpen() throws IOException {
        InputStream inputStream = this.in;
        RuntimeCostAccounter.recordJump();
        if (inputStream == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Stream closed");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
        return inputStream;
    }

    private byte[] getBufIfOpen() throws IOException {
        byte[] byArray = this.buf;
        RuntimeCostAccounter.recordJump();
        if (byArray == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Stream closed");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
        return byArray;
    }

    public BufferedInputStream(InputStream inputStream) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedInputStream.<init>:(Ljava/io/InputStream;I)V");
        this(inputStream, DEFAULT_BUFFER_SIZE);
    }

    public BufferedInputStream(InputStream inputStream, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FilterInputStream.<init>:(Ljava/io/InputStream;)V");
        super(inputStream);
        this.markpos = -1;
        RuntimeCostAccounter.recordJump();
        if (n <= 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Buffer size <= 0");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        int n2 = n;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)1);
        this.buf = new byte[n2];
    }

    private void fill() throws IOException {
        int n;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedInputStream.getBufIfOpen:()[B");
        byte[] byArray = this.getBufIfOpen();
        RuntimeCostAccounter.recordJump();
        if (this.markpos < 0) {
            this.pos = 0;
            RuntimeCostAccounter.recordJump();
        } else {
            int n2 = byArray.length;
            RuntimeCostAccounter.recordJump();
            if (this.pos >= n2) {
                RuntimeCostAccounter.recordJump();
                if (this.markpos > 0) {
                    n = this.pos - this.markpos;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                    System.arraycopy(byArray, this.markpos, byArray, 0, n);
                    this.pos = n;
                    this.markpos = 0;
                    RuntimeCostAccounter.recordJump();
                } else {
                    int n3 = byArray.length;
                    RuntimeCostAccounter.recordJump();
                    if (n3 >= this.marklimit) {
                        this.markpos = -1;
                        this.pos = 0;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        int n4;
                        int n5 = byArray.length;
                        RuntimeCostAccounter.recordJump();
                        if (n5 >= MAX_BUFFER_SIZE) {
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/OutOfMemoryError");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/OutOfMemoryError.<init>:(Ljava/lang/String;)V");
                            OutOfMemoryError outOfMemoryError = new OutOfMemoryError("Required array size too large");
                            RuntimeCostAccounter.recordThrow();
                            throw outOfMemoryError;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (this.pos <= MAX_BUFFER_SIZE - this.pos) {
                            n4 = this.pos * 2;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            n4 = MAX_BUFFER_SIZE;
                        }
                        n = n4;
                        RuntimeCostAccounter.recordJump();
                        if (n > this.marklimit) {
                            n = this.marklimit;
                        }
                        int n6 = n;
                        RuntimeCostAccounter.recordArrayAllocation((int)n6, (int)1);
                        byte[] byArray2 = new byte[n6];
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                        System.arraycopy(byArray, 0, byArray2, 0, this.pos);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReferenceFieldUpdater.compareAndSet:(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z");
                        boolean bl = bufUpdater.compareAndSet(this, byArray, byArray2);
                        RuntimeCostAccounter.recordJump();
                        if (!bl) {
                            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                            IOException iOException = new IOException("Stream closed");
                            RuntimeCostAccounter.recordThrow();
                            throw iOException;
                        }
                        byArray = byArray2;
                    }
                }
            }
        }
        this.count = this.pos;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedInputStream.getInIfOpen:()Ljava/io/InputStream;");
        InputStream inputStream = this.getInIfOpen();
        int n7 = byArray.length - this.pos;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.read:([BII)I");
        n = inputStream.read(byArray, this.pos, n7);
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            this.count = n + this.pos;
        }
    }

    @Override
    public synchronized int read() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.pos >= this.count) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedInputStream.fill:()V");
            this.fill();
            RuntimeCostAccounter.recordJump();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedInputStream.getBufIfOpen:()[B");
        return this.getBufIfOpen()[this.pos++] & 0xFF;
    }

    private int read1(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = this.count - this.pos;
        RuntimeCostAccounter.recordJump();
        if (n4 <= 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedInputStream.getBufIfOpen:()[B");
            int n5 = this.getBufIfOpen().length;
            RuntimeCostAccounter.recordJump();
            if (n2 >= n5) {
                RuntimeCostAccounter.recordJump();
                if (this.markpos < 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedInputStream.getInIfOpen:()Ljava/io/InputStream;");
                    InputStream inputStream = this.getInIfOpen();
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.read:([BII)I");
                    return inputStream.read(byArray, n, n2);
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedInputStream.fill:()V");
            this.fill();
            n4 = this.count - this.pos;
            RuntimeCostAccounter.recordJump();
            if (n4 <= 0) {
                return -1;
            }
        }
        RuntimeCostAccounter.recordJump();
        if (n4 < n2) {
            n3 = n4;
            RuntimeCostAccounter.recordJump();
        } else {
            n3 = n2;
        }
        int n6 = n3;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedInputStream.getBufIfOpen:()[B");
        byte[] byArray2 = this.getBufIfOpen();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
        System.arraycopy(byArray2, this.pos, byArray, n, n6);
        this.pos += n6;
        return n6;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedInputStream.getBufIfOpen:()[B");
        this.getBufIfOpen();
        int n3 = n | n2 | n + n2 | byArray.length - (n + n2);
        RuntimeCostAccounter.recordJump();
        if (n3 < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:()V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            return 0;
        }
        int n4 = 0;
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedInputStream.read1:([BII)I");
            int n5 = this.read1(byArray, n + n4, n2 - n4);
            RuntimeCostAccounter.recordJump();
            if (n5 <= 0) {
                int n6;
                RuntimeCostAccounter.recordJump();
                if (n4 == 0) {
                    n6 = n5;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n6 = n4;
                }
                return n6;
            }
            RuntimeCostAccounter.recordJump();
            if ((n4 += n5) >= n2) {
                return n4;
            }
            InputStream inputStream = this.in;
            RuntimeCostAccounter.recordJump();
            if (inputStream != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.available:()I");
                int n7 = inputStream.available();
                RuntimeCostAccounter.recordJump();
                if (n7 <= 0) {
                    return n4;
                }
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    @Override
    public synchronized long skip(long l) throws IOException {
        long l2;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedInputStream.getBufIfOpen:()[B");
        this.getBufIfOpen();
        RuntimeCostAccounter.recordJump();
        if (l <= 0L) {
            return 0L;
        }
        long l3 = this.count - this.pos;
        RuntimeCostAccounter.recordJump();
        if (l3 <= 0L) {
            RuntimeCostAccounter.recordJump();
            if (this.markpos < 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedInputStream.getInIfOpen:()Ljava/io/InputStream;");
                InputStream inputStream = this.getInIfOpen();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.skip:(J)J");
                return inputStream.skip(l);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedInputStream.fill:()V");
            this.fill();
            l3 = this.count - this.pos;
            RuntimeCostAccounter.recordJump();
            if (l3 <= 0L) {
                return 0L;
            }
        }
        RuntimeCostAccounter.recordJump();
        if (l3 < l) {
            l2 = l3;
            RuntimeCostAccounter.recordJump();
        } else {
            l2 = l;
        }
        long l4 = l2;
        this.pos = (int)((long)this.pos + l4);
        return l4;
    }

    @Override
    public synchronized int available() throws IOException {
        int n;
        int n2 = this.count - this.pos;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedInputStream.getInIfOpen:()Ljava/io/InputStream;");
        InputStream inputStream = this.getInIfOpen();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.available:()I");
        int n3 = inputStream.available();
        RuntimeCostAccounter.recordJump();
        if (n2 > Integer.MAX_VALUE - n3) {
            n = Integer.MAX_VALUE;
            RuntimeCostAccounter.recordJump();
        } else {
            n = n2 + n3;
        }
        return n;
    }

    @Override
    public synchronized void mark(int n) {
        this.marklimit = n;
        this.markpos = this.pos;
    }

    @Override
    public synchronized void reset() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedInputStream.getBufIfOpen:()[B");
        this.getBufIfOpen();
        RuntimeCostAccounter.recordJump();
        if (this.markpos < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Resetting to invalid mark");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
        this.pos = this.markpos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() throws IOException {
        block2: {
            boolean bl;
            do {
                byte[] byArray = this.buf;
                RuntimeCostAccounter.recordJump();
                if (this.buf == null) break block2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReferenceFieldUpdater.compareAndSet:(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z");
                bl = bufUpdater.compareAndSet(this, byArray, null);
                RuntimeCostAccounter.recordJump();
            } while (!bl);
            InputStream inputStream = this.in;
            this.in = null;
            RuntimeCostAccounter.recordJump();
            if (inputStream != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.close:()V");
                inputStream.close();
            }
            return;
        }
    }

    static {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReferenceFieldUpdater.newUpdater:(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/String;)Ljava/util/concurrent/atomic/AtomicReferenceFieldUpdater;");
        bufUpdater = AtomicReferenceFieldUpdater.newUpdater(BufferedInputStream.class, byte[].class, "buf");
    }
}

