# Distributing Apps With Electron Forge

Electron Forge is a tool for packaging and publishing Electron applications.
It unifies Electron's build tooling ecosystem into
a single extensible interface so that anyone can jump right into making Electron apps.

## Getting started

The [Electron Forge docs] contain detailed information on taking your application
from source code to your end users' machines.
This includes:

* Packaging your application [(package)]
* Generating executables and installers for each OS [(make)], and,
* Publishing these files to online platforms to download [(publish)].

For beginners, we recommend following through Electron's [tutorial] to develop, build,
package and publish your first Electron app. If you have already developed an app on your machine
and want to start on packaging and distribution, start from [step 5] of the tutorial.

## Getting help

* If you need help with developing your app, our [community Discord server][discord] is a great place
to get advice from other Electron app developers.
* If you suspect you're running into a bug with Forge, please check the [GitHub issue tracker]
to see if any existing issues match your problem. If not, feel free to fill out our bug report
template and submit a new issue.

[Electron Forge Docs]: https://www.electronforge.io/
[step 5]: ./tutorial-5-packaging.md
[(package)]: https://www.electronforge.io/cli#package
[(make)]: https://www.electronforge.io/cli#make
[(publish)]: https://www.electronforge.io/cli#publish
[GitHub issue tracker]: https://github.com/electron-userland/electron-forge/issues
[discord]: https://discord.gg/APGC3k5yaH
[tutorial]: https://www.electronjs.org/docs/latest/tutorial/tutorial-prerequisites
