---
title: 'ASAR Integrity'
description: 'An experimental feature that ensures the validity of ASAR contents at runtime.'
slug: asar-integrity
hide_title: false
---

## Platform Support

Currently ASAR integrity checking is only supported on macOS.

## Requirements

### Electron Forge / Electron Packager

If you are using `>= electron-packager@15.4.0` or `>= @electron-forge/core@6.0.0-beta.61` then all these requirements are met for you automatically and you can skip to [Toggling the Fuse](#toggling-the-fuse).

### Other build systems

In order to enable ASAR integrity checking you need to ensure that your `app.asar` file was generated by a version of the `asar` npm package that supports asar integrity.  Support was introduced in version `3.1.0`.

Your must then populate a valid `ElectronAsarIntegrity` dictionary block in your packaged apps `Info.plist`.  An example is included below.

```plist
<key>ElectronAsarIntegrity</key>
<dict>
  <key>Resources/app.asar</key>
  <dict>
    <key>algorithm</key>
    <string>SHA256</string>
    <key>hash</key>
    <string>9d1f61ea03c4bb62b4416387a521101b81151da0cfbe18c9f8c8b818c5cebfac</string>
  </dict>
</dict>
```

Valid `algorithm` values are currently `SHA256` only.  The `hash` is a hash of the ASAR header using the given algorithm.  The `asar` package exposes a `getRawHeader` method whose result can then be hashed to generate this value.

## Toggling the Fuse

ASAR integrity checking is currently disabled by default and can be enabled by toggling a fuse. See [Electron Fuses](fuses.md) for more information on what Electron Fuses are and how they work.  When enabling this fuse you typically also want to enable the `onlyLoadAppFromAsar` fuse otherwise the validity checking can be bypassed via the Electron app code search path.

```js
require('@electron/fuses').flipFuses(
  // E.g. /a/b/Foo.app
  pathToPackagedApp,
  {
    version: FuseVersion.V1,
    [FuseV1Options.EnableEmbeddedAsarIntegrityValidation]: true,
    [FuseV1Options.OnlyLoadAppFromAsar]: true
  }
)
```
