# Put the line below in ~/.zshrc:
#
#   eval "$(kite jump shell zsh)"
#   # set the bind func name is: j
#   eval "$(kite jump shell zsh --bind j)"
#
# The following lines are autogenerated:

# change pwd hook
__jump_chpwd() {
  kite jump chdir
}

typeset -gaU chpwd_functions
chpwd_functions+=(__jump_chpwd)

_jump_completion() {
   # reply="'$(kite jump hint "$@")'"
   # reply=('test1' 'test2')

   # local -a commands
   typeset -a commands

   # commands for use `_values`
   #commands+=('test1[/path/to/dir1]' 'test2[/path/to/dir2]')
   #_values 'jump dirs' ${commands[@]}

   # commands for use `_describe`
   commands+=('test1:/path/to/dir1' 'test2:/path/to/dir2')
   _describe 'commands' commands
}

j() {
  local dir
  dir=$(kite jump cd "$@")
  test -d "$dir" && cd "$dir"
}

# for use `reply`
# compctl -U -K _jump_completion j

# for use `_describe`
compdef _jump_completion 'j'