# Put the line below in ~/.zshrc:
#
#   eval "$(kite jump shell zsh)"
#   # set the bind func name is: j
#   eval "$(kite jump shell zsh --bind j)"
#
# for DEBUG:
#   set -x # start
#   set +x # stop
#   typeset -ft __jump_chpwd # start for given function
#   typeset +ft __jump_chpwd # stop
#
# The following lines are autogenerated:

# change pwd hook
__jump_chpwd() {
    # eg:
    # ': 1649259804:0;j /path/to'
    # => x=':' cmd='1649259804:0;j' args='/path/to'
    local midStr=$(tail -n 1 $HOME/.zsh_history | {
        read x cmd args
        echo "$cmd"
    })

    local lastCmd=${midStr#*;}
    # Do not process other commands executed
    if [[ $lastCmd != "{{bindFunc}}" ]]; then
        return 0
    fi

    kite jump chdir
}

typeset -gaU chpwd_functions
chpwd_functions+=(__jump_chpwd)

# completion func for {{bindFunc}}
_jump_completion() {
    local state
    typeset -a commands histories

    kite util log "current $@ $#" --type "jump-comp1"
    kite util log "words: $words (w1: $words[1] w2: $words[2]) state: $state" --type "jump-comp2"

    # commands+=($(kite jump hint "$@"))
    commands+=($(kite jump hint $words[2] --flag 1))
    histories+=($(kite jump hint $words[2] --flag 2))
    #  _describe -t 'commands' commands
    _describe 'commands' commands -- histories
    _alternative \
        'files:filename:_files'
}

{{bindFunc}}() {
    local dir
    dir=$(kite jump get "$@")
    test -d "$dir" && cd "$dir"
}

# for use `reply`
# compctl -U -K _jump_completion {{bindFunc}}
# for use `_describe`
compdef _jump_completion '{{bindFunc}}'
# compctl -U -K _jump_completion {{bindFunc}}

# add alias for: kite jump
alias kj="kite jump"
