import { TTypeRef } from './types/sharedTypes';
import { TApiReferenceJson } from './types/types';

const DELIMITER = ' |\n';
const dtsTemplate = (content: string) => {
    return `type Autogenerated_TDocsGenExportedTypeRef = ${content};\n`;
};

export function generateDTS(res: TApiReferenceJson) {
    const allRefs = Object.keys(res.docsGenTypes) as TTypeRef[];
    const exportedRefs = allRefs.reduce<string[]>((acc, typeRef) => {
        if (res.docsGenTypes[typeRef].summary.exported) {
            acc.push(`'${typeRef}'`);
        }
        return acc;
    }, []);
    const content = exportedRefs.join(DELIMITER);
    return dtsTemplate(content);
}
