import '../styles/globals.css';
import '@epam/uui-components/styles.css';
import '@epam/uui/styles.css';
import '@epam/assets/theme/theme_loveship.scss';
import { PropsWithChildren } from 'react';
import { AppView } from '../components/AppView';

export default function RootLayout({ children }: PropsWithChildren) {
    return (
        <html lang='en'>
            <head>
                <title>Create Next App</title>
                <meta
                    name='viewport'
                    content='width=device-width, initial-scale=1'
                />
                <meta
                    name='description'
                    content='Generated by create next app'
                />
                <link
                    rel='icon'
                    href='/favicon.ico'
                />
            </head>
            <body className='uui-theme-loveship'>
                <AppView>{children}</AppView>
            </body>
        </html>
    );
}
