# [name]

## Motivation

Give a short description of the motivation behind this change to give some
context without diving too deeply into details:

- Why does it need to be done?
- What use cases does it support?
- What is the expected outcome?

## Guide-level explanation

Explain the proposal as if it was already in the codebase and one were
explaining it to a consumer. That generally means:

- Description of an exposed interface.
- Explaining the feature largely in terms of examples.
- Explaining how consumers should think about the feature, and how it should
  impact the way they use the application. It should explain the impact as
  concretely as possible.
- Provide sample error messages, deprecation warnings, or migration guidance.
- Describe impact on all customers in great detail; Operators, Riders and
  Developers in particular.

## Reference-level explanation

This is the technical portion of the RFC. Explain the design in sufficient
detail such that:

- Its interaction with other features is clear.
- It is clear how the feature would be implemented.
- It is clear what new technologies and techniques will be used to implement the
  feature.
- Corner cases are dissected by example.

The section should return to the examples given in the previous section, and
explain more fully how the detailed proposal makes those examples work.

## Drawbacks

Why should it not be done?

## Rationale and alternatives

- Why is this design the best in the space of possible designs?
- What other designs have been considered and what is the rationale for not
  choosing them?
- What is the impact of not doing this?

## Prior art

Discuss prior art, both the good and the bad, in relation to this proposal. A
few examples of what this can include are:

- Does this feature exist in similar applications, APIs?
- If done by some other community, what were their experiences with it and how
  may we learn from them?
- Are there any published papers or great posts that discuss this?

This section is intended to encourage you as an author to think about the
lessons from other languages and provide readers of your RFC with a fuller
picture. If there is no prior art, that is fine - your ideas are interesting
whether they are brand new or if they are an adaptation from other languages.

## Unresolved questions

- What parts of the design do you expect to resolve through the RFC process
  before this gets merged?
- What parts of the design do you expect to resolve through the implementation
  of this feature before stabilization?
- What related issues do you consider out of scope for this RFC that could be
  addressed in the future independently of the solution that comes out of this
  RFC?

## Future possibilities

Think about what the natural extension and evolution of your proposal would be
and how it would affect the application and project as a whole in a holistic
way. Try to use this section as a tool to more fully consider all possible
interactions with the project in your proposal. Also consider how all of it fits
into the road map for the project and of the relevant sub-team.

This is also a good place to "dump ideas" if they are out of scope for the RFC
you are writing but otherwise related.

If you have tried and cannot think of any future possibilities, you may simply
state that you cannot think of anything.

Note that having something written down in the future-possibilities section is
not a reason to accept the current or a future RFC; such notes should be in the
section on motivation or rationale in this or subsequent RFCs. The section
merely provides additional information.
