<?php

/**
 * @copyright Copyright (C) Ibexa AS. All rights reserved.
 * @license For full copyright and license information view LICENSE file distributed with this source code.
 */
declare(strict_types=1);

namespace Ibexa\Core\Persistence\Legacy\SharedGateway\DatabasePlatform;

use Doctrine\DBAL\Connection;
use Ibexa\Core\Persistence\Legacy\SharedGateway\Gateway;

/**
 * @internal
 */
abstract class AbstractGateway implements Gateway
{
    protected Connection $connection;

    public function __construct(Connection $connection)
    {
        $this->connection = $connection;
    }

    public function getColumnNextIntegerValue(
        string $tableName,
        string $columnName,
        string $sequenceName
    ): ?int {
        return null;
    }

    /**
     * Return a language sub select query for setName.
     *
     * The query generates the proper language mask at the runtime of the INSERT/UPDATE query
     * generated by setName.
     *
     * @see setName
     */
    public function getSetNameLanguageMaskSubQuery(): string
    {
        return <<<SQL
            (SELECT
                CASE
                    WHEN (initial_language_id = :language_id AND (language_mask & :language_id) <> 0 )
                    THEN (:language_id | 1)
                    ELSE :language_id
                END
                FROM ibexa_content
                WHERE id = :content_id)
            SQL;
    }

    public function getLastInsertedId(string $sequenceName): int
    {
        return (int)$this->connection->lastInsertId($sequenceName);
    }
}
