<?php

/**
 * @copyright Copyright (C) Ibexa AS. All rights reserved.
 * @license For full copyright and license information view LICENSE file distributed with this source code.
 */
declare(strict_types=1);

namespace Ibexa\Core\Persistence\Legacy\Notification\Gateway\CriterionHandler;

use Doctrine\DBAL\ArrayParameterType;
use Doctrine\DBAL\Query\QueryBuilder;
use Ibexa\Contracts\Core\Repository\Values\Notification\CriterionHandlerInterface;
use Ibexa\Contracts\Core\Repository\Values\Notification\Query\Criterion\Status;
use Ibexa\Contracts\Core\Repository\Values\Notification\Query\CriterionInterface;
use Ibexa\Core\Persistence\Legacy\Notification\Gateway\DoctrineDatabase;

/**
 * @implements \Ibexa\Contracts\Core\Repository\Values\Notification\CriterionHandlerInterface<Status>
 */
final class StatusCriterionHandler implements CriterionHandlerInterface
{
    public function supports(CriterionInterface $criterion): bool
    {
        return $criterion instanceof Status;
    }

    public function apply(QueryBuilder $qb, CriterionInterface $criterion): void
    {
        $qb->andWhere($qb->expr()->eq(DoctrineDatabase::COLUMN_IS_PENDING, ':status'));
        $qb->setParameter('status', $criterion->getStatuses(), ArrayParameterType::STRING);
    }
}
