<?php

/**
 * @copyright Copyright (C) Ibexa AS. All rights reserved.
 * @license For full copyright and license information view LICENSE file distributed with this source code.
 */
declare(strict_types=1);

namespace Ibexa\Contracts\Core\Repository\Events\Section;

use Ibexa\Contracts\Core\Repository\Event\AfterEvent;
use Ibexa\Contracts\Core\Repository\Values\Content\Section;

final class DeleteSectionEvent extends AfterEvent
{
    private Section $section;

    public function __construct(
        Section $section
    ) {
        $this->section = $section;
    }

    public function getSection(): Section
    {
        return $this->section;
    }
}
