<?php

/**
 * @copyright Copyright (C) Ibexa AS. All rights reserved.
 * @license For full copyright and license information view LICENSE file distributed with this source code.
 */

namespace Ibexa\Core\Search\Common\FieldValueMapper;

use Ibexa\Contracts\Core\Search\Field;
use Ibexa\Contracts\Core\Search\FieldType\MultipleIntegerField;

/**
 * Common multiple integer field value mapper implementation.
 */
class MultipleIntegerMapper extends IntegerMapper
{
    public function canMap(Field $field): bool
    {
        return $field->getType() instanceof MultipleIntegerField;
    }

    public function map(Field $field)
    {
        $values = [];

        foreach ((array)$field->getValue() as $value) {
            $values[] = $this->convert($value);
        }

        return $values;
    }
}
