<?php

/**
 * @copyright Copyright (C) Ibexa AS. All rights reserved.
 * @license For full copyright and license information view LICENSE file distributed with this source code.
 */
declare(strict_types=1);

namespace Ibexa\Core\MVC\Symfony\Locale;

use Symfony\Component\HttpFoundation\Request;

/**
 * Provides list of user-preferred languages.
 */
interface UserLanguagePreferenceProviderInterface
{
    /**
     * Return a list of user's browser preferred locales directly from Accept-Language header.
     *
     * @return string[]
     */
    public function getPreferredLocales(?Request $request = null): array;

    /**
     * List of Ibexa Language codes.
     *
     * @return string[]
     */
    public function getPreferredLanguages(): array;
}
