<?php

/**
 * @copyright Copyright (C) Ibexa AS. All rights reserved.
 * @license For full copyright and license information view LICENSE file distributed with this source code.
 */
declare(strict_types=1);

namespace Ibexa\Core\Persistence\Legacy\SharedGateway\DatabasePlatform;

final class PostgresqlGateway extends AbstractGateway
{
    /**
     * Return a language sub select query for setName.
     *
     * The query generates the proper language mask at the runtime of the INSERT/UPDATE query
     * generated by setName.
     *
     * @see setName
     */
    public function getSetNameLanguageMaskSubQuery(): string
    {
        return <<<SQL
            (SELECT
                CASE
                    WHEN (initial_language_id = :language_id AND (language_mask & :language_id) <> 0 )
                    THEN (cast(:language_id as BIGINT) | 1)
                    ELSE :language_id
                END
                FROM ezcontentobject
                WHERE id = :content_id)
            SQL;
    }
}
