<?php

/**
 * @copyright Copyright (C) Ibexa AS. All rights reserved.
 * @license For full copyright and license information view LICENSE file distributed with this source code.
 */
declare(strict_types=1);

namespace Ibexa\Core\Limitation\LanguageLimitation;

use Ibexa\Contracts\Core\Limitation\Target;
use Ibexa\Contracts\Core\Repository\Values\Content\VersionInfo;
use Ibexa\Contracts\Core\Repository\Values\User\Limitation;
use Ibexa\Core\Limitation\LanguageLimitationType;

/**
 * @internal for internal use by LanguageLimitation
 */
final class NewDraftEvaluator implements VersionTargetEvaluator
{
    public function accept(Target\Version $targetVersion): bool
    {
        return $targetVersion->newStatus === VersionInfo::STATUS_DRAFT;
    }

    public function evaluate(Target\Version $targetVersion, Limitation $limitationValue): ?bool
    {
        return LanguageLimitationType::ACCESS_GRANTED;
    }
}

class_alias(NewDraftEvaluator::class, 'eZ\Publish\Core\Limitation\LanguageLimitation\NewDraftEvaluator');
