<?php

/**
 * @copyright Copyright (C) Ibexa AS. All rights reserved.
 * @license For full copyright and license information view LICENSE file distributed with this source code.
 */
declare(strict_types=1);

namespace Ibexa\Contracts\Core\Repository\Values\URL\Query\Criterion;

/**
 * Matches URLs which contains the pattern.
 */
class Pattern extends Matcher
{
    /**
     * String which needs to part of URL e.g. ibexa.co.
     *
     * @var string
     */
    public $pattern;

    /**
     * Pattern constructor.
     *
     * @param string $pattern
     */
    public function __construct(string $pattern)
    {
        if ($pattern === '') {
            throw new \InvalidArgumentException('URL pattern cannot be empty.');
        }

        $this->pattern = $pattern;
    }
}

class_alias(Pattern::class, 'eZ\Publish\API\Repository\Values\URL\Query\Criterion\Pattern');
