<?php

/**
 * @copyright Copyright (C) Ibexa AS. All rights reserved.
 * @license For full copyright and license information view LICENSE file distributed with this source code.
 */
namespace Ibexa\Bundle\Core\Imagine\Filter\Loader;

use Imagine\Exception\InvalidArgumentException;
use Imagine\Image\ImageInterface;

/**
 * Filter loader for geometry/scaleexact filter.
 * Proxy to ThumbnailFilterLoader.
 */
class ScalePercentFilterLoader extends FilterLoaderWrapped
{
    public const IDENTIFIER = 'geometry/scalepercent';

    public function load(ImageInterface $image, array $options = [])
    {
        if (count($options) < 2) {
            throw new InvalidArgumentException('Missing width and/or height percent options');
        }

        $size = $image->getSize();
        $origWidth = $size->getWidth();
        $origHeight = $size->getHeight();
        list($widthPercent, $heightPercent) = $options;

        $targetWidth = ($origWidth * $widthPercent) / 100;
        $targetHeight = ($origHeight * $heightPercent) / 100;

        return $this->innerLoader->load($image, ['size' => [$targetWidth, $targetHeight]]);
    }
}

class_alias(ScalePercentFilterLoader::class, 'eZ\Bundle\EzPublishCoreBundle\Imagine\Filter\Loader\ScalePercentFilterLoader');
