<?php
/**
 * Wrapper for CVSGraph.
 *
 * Copyright 1999-2017 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.horde.org/licenses/gpl.
 *
 * @author  Anil Madhavapeddy <anil@recoil.org>
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @package Chora
 */

require_once __DIR__ . '/lib/Application.php';
Horde_Registry::appInit('chora');

// Exit if cvsgraph isn't active or it's not supported.
if (empty($conf['paths']['cvsgraph']) || !$VC->hasFeature('branches')) {
    Chora::url('browsefile', $where)->redirect();
}

if (!is_file($fullname . ',v')) {
    Chora::fatal(sprintf(_("%s: no such file or directory"), $where), '404 Not Found');
}

$root = escapeShellCmd($VC->sourceroot);
$file = escapeShellCmd($where . ',v');

if (Horde_Util::getFormData('show_image')) {
    // Pipe out the actual image.
    $args = array('c' => $conf['paths']['cvsgraph_conf'],
                  'r' => $root);

    // Build up the argument string.
    $argstr = '';
    if (!strncasecmp(PHP_OS, 'WIN', 3)) {
        foreach ($args as $key => $val) {
            $argstr .= "-$key \"$val\" ";
        }
    } else {
        foreach ($args as $key => $val) {
            $argstr .= "-$key '$val' ";
        }
    }

    header('Content-Type: image/png');
    passthru($conf['paths']['cvsgraph'] . ' ' . $argstr . ' ' . $file);
    exit;
}

// Display the wrapper page for the image.
$title = _("Graph for:");

Chora::header($title);
echo Chora::getHistoryViews($where)->render('cvsgraph');

$imgUrl = Chora::url('cvsgraph', $where, array('show_image' => 1));

$args = array('c' => $conf['paths']['cvsgraph_conf'],
              'M' => 'graphMap',
              'r' => $root,
              '0' => '&amp;',
              '1' => Chora::url('browsefile', $where, array('dummy' => 'true')),
              '2' => Chora::url('diff', $where, array('dummy' =>'true')),
              '3' => Chora::url('co', $where, array('dummy' => 'true')),
);

// Build up the argument string.
$argstr = '';
if (!strncasecmp(PHP_OS, 'WIN', 3)) {
    foreach ($args as $key => $val) {
        $argstr .= "-$key \"$val\" ";
    }
} else {
    foreach ($args as $key => $val) {
        $argstr .= "-$key '$val' ";
    }
}

// Generate the imagemap.
$map = shell_exec($conf['paths']['cvsgraph'] . ' ' . $argstr . ' -i ' . $file);

require CHORA_TEMPLATES . '/cvsgraph/cvsgraph.inc';
$page_output->footer();
