<?php
/**
 * This file contains example configuration information for various source
 * repositories that you may wish to display. You should enable a minimum of
 * one entry!  Each entry requires a unique key name.
 *
 * IMPORTANT: DO NOT EDIT THIS FILE!
 * Local overrides MUST be placed in backends.local.php or backends.d/.
 * If the 'vhosts' setting has been enabled in Horde's configuration, you can
 * use backends-servername.php.
 *
 * Example configuration file that enables the Git repository and sets a
 * location:
 *
 * <?php
 * $sourceroots['git']['disabled'] = false;
 * $sourceroots['git']['location'] = '/srv/git/repository';
 *
 * The following fields can be defined for each repository:
 *   - name: (string) [REQUIRED] Short name for the repository.
 *   - location: (string) [REQUIRED] Location of repository. Depending on the
 *               repository 'type', this could be a URL or a file system path.
 *   - title: (string) [REQUIRED] Long title for the repository.
 *   - type: (string) [REQUIRED] The driver type.  Either 'cvs', 'rcs', 'svn',
 *           or 'git'.
 *   - default: (boolean) If true, makes repository the default one to show.
 *   - intro: (string) File which contains some introductory text to show on
 *            the front page of this repository.  This file MUST be located
 *            in the config/ directory.
 *   - restrictions: (array) List of perl-style regular expressions for those
 *                   files whose contents should be protected and not
 *                   displayed.
 *
 * The following fields can be defined for CVS repositories:
 *   - cvsusers: (string) A list of all committers with real names and email
 *               addresses, that normally sits in the CVSROOT/cvsusers file.
 *               If it is found, then more useful information will be shown.
 *
 * The following fields can be defined for SVN repositories:
 *   - username: (string) Username to use for the repository.
 *   - password: (string) Password to use for the repository.
 */

$sourceroots['localcvs'] = array(
    'disabled' => true,
    'name' => 'CVS',
    'location' => '/path/to/cvs/repo',
    'title' => 'CVS Repository',
    'cvsusers' => 'CVSROOT/cvsusers',
    'type' => 'cvs',
);

$sourceroots['subversion'] = array(
    'disabled' => true,
    'name' => 'Subversion',
    'location' => 'http://svn.example.com/repos/svn',
    'title' => 'Subversion Repository',
    'type' => 'svn'
);

$sourceroots['localsvn'] = array(
    'disabled' => true,
    'name' => 'Subversion',
    'location' => '/path/to/svn/repo',
    'title' => 'Subversion Repository',
    'type' => 'svn',
);

$sourceroots['git'] = array(
    'disabled' => true,
    'name' => 'Git',
    'location' => '/path/to/git/repo',
    'title' => 'Git Repository',
    'type' => 'git',
);
