<?php
/**
 * The Hylax script to show a fax view.
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.horde.org/licenses/gpl.
 */

require_once __DIR__ . '/lib/Application.php';
$hylax = Horde_Registry::appInit('hylax');

$fax_id = Horde_Util::getFormData('fax_id');
if (!($url = Horde::verifySignedUrl(Util::getFormData('url')))) {
    $url = 'folder.php';
}
$print = Hylax::printFax($fax_id);
if (is_a($print, 'PEAR_Error')) {
    $notification->push(sprintf(_("Could not print fax ID \"%s\". %s"), $fax_id, $print->getMessage()), 'horde.error');
} else {
    $notification->push(sprintf(_("Printed fax ID \"%s\"."), $fax_id), 'horde.success');
}

/* Redirect back. */
Horde::url($url, true)->redirect();
