-- MySQL dump 10.11
--
-- Host: localhost    Database: planet
-- ------------------------------------------------------
-- Server version	5.0.45

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `blogs`
--

DROP TABLE IF EXISTS `blogs`;
CREATE TABLE `blogs` (
  `ID` int(11) NOT NULL auto_increment,
  `link` varchar(255) NOT NULL default '',
  `title` varchar(255) NOT NULL default '',
  `description` tinytext,
  `changed` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `author` varchar(100) NOT NULL default '',
  `dontshowblogtitle` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`ID`),
  UNIQUE KEY `link` (`link`)
) ENGINE=MyISAM AUTO_INCREMENT=46 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `blogs`
--

LOCK TABLES `blogs` WRITE;
/*!40000 ALTER TABLE `blogs` DISABLE KEYS */;
INSERT INTO `blogs` VALUES (2,'http://janschneider.de/','Jan Schneider','News from the Horde Project','2008-02-26 19:56:57','',1),(17,'http://hagenbu.ch/','Chuck Hagenbuch','Chuck\'s blog, links, news, ramblings','2008-02-26 19:56:30','',1),(28,'http://mikenaberezny.com','Mike Naberezny','','2008-02-27 04:18:55','',1),(31,'http://theupstairsroom.com/','Michael Rubinsky','News to display on theUpstairsRoom.com website.','2008-02-26 22:28:29','',1),(45,'http://log.onthebrink.de/','Gunnar Wrobel',NULL,'2008-02-27 16:47:03','',1);
/*!40000 ALTER TABLE `blogs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `entries`
--

DROP TABLE IF EXISTS `entries`;
CREATE TABLE `entries` (
  `ID` int(11) NOT NULL default '0',
  `feedsID` int(11) NOT NULL default '0',
  `title` tinytext,
  `link` tinytext NOT NULL,
  `guid` varchar(255) NOT NULL,
  `description` text,
  `dc_date` datetime default '0000-00-00 00:00:00',
  `dc_creator` varchar(100) default NULL,
  `content_encoded` text,
  `changed` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `md5` varchar(32) NOT NULL default '',
  PRIMARY KEY  (`ID`),
  UNIQUE KEY `link` (`link`(250)),
  KEY `rss_feed_ID` (`feedsID`),
  FULLTEXT KEY `search` (`description`,`content_encoded`,`title`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `entries`
--

LOCK TABLES `entries` WRITE;
/*!40000 ALTER TABLE `entries` DISABLE KEYS */;
INSERT INTO `entries` VALUES (7,1,'Patch library in PHP?','http://janschneider.de/news/35/318','http://janschneider.de/news/35/318','Does anybody know a good patch library in PHP? Like a counterpart to Text_Diff.\nI know that it\'s trivial to apply a clean patch file with a few lines of code, but I\'m looking for a more complete solution, especially with fuzzy patching capabilities.','2007-12-16 13:57:31','','','2008-02-25 21:42:48','7dcd12a5e870370a00fb52f16781b683'),(8,1,'Webmail comparison of DIMP, Roundcube and Scalix','http://janschneider.de/news/35/317','http://janschneider.de/news/35/317','As I mentioned in an earlier blog post about the article that I wrote for Linux Magazin Technical Review, there is another article from Linux Magazin which compares the AJAX webmail solutions DIMP, Roundcube, and the webmail component of Scalix. Here\'s a short summary.','2007-12-04 14:06:59','','','2008-02-25 21:42:48','e447af5e4850343c67d1baa7d1183608'),(9,1,'\"The Michigan Daily\" about Horde','http://janschneider.de/news/35/313','http://janschneider.de/news/35/313','The Michigan Daily released an article today about the University of Michigan NOT switching their mail system over to Google. They use Horde and IMP and the moment and seem to be very happy with it. There are more reasons why organizations and companies should not move to Gmail or Hotmail.','2007-11-21 23:26:00','','','2008-02-25 21:42:48','bf06d113f608c8a49036e3216b9176ff'),(10,1,'Article in Linux Magazin','http://janschneider.de/news/35/312','http://janschneider.de/news/35/312','An article about Horde has been released in a groupware edition of the German \"Linux Magazine - Technical Review\".','2007-11-20 12:19:00','','','2008-02-25 21:42:48','e01c82956ef670c0e0add982226eb894'),(11,1,'Kolab web client finished','http://janschneider.de/news/35/309','http://janschneider.de/news/35/309','From Gunnar Wrobel through the Kolab mailing lists: Kolab support in Horde is finally considered feature complete!','2007-05-30 22:02:28','','','2008-02-25 21:42:48','dcb37a899fd0d6f0c6e97b646ebeff9a'),(12,1,'Introduction to Horde_Lens','http://janschneider.de/news/35/308','http://janschneider.de/news/35/308','Chuck has written an introduction to the new Horde_Lens library: \"Horde_Lens is a decorating iterator implementation that lets you look at every element of a list through the lens of a Flyweight decorator object.\"','2007-05-14 22:11:32','','','2008-02-25 21:42:48','d0efa0368971d3a6539b096223ca183a'),(13,1,'Shop is open','http://janschneider.de/news/35/307','http://janschneider.de/news/35/307','It was just started for personal purposes, to get some Horde T-Shirts printed, but I was asked to make it open to the public. So here it is, the merchandising shop for the Horde Project.','2007-05-10 09:16:50','','','2008-02-25 21:42:48','0df3e97e67c60ad700ba60093617f824'),(14,1,'Nice new icon sets for Horde','http://janschneider.de/news/35/306','http://janschneider.de/news/35/306','Daniel Dembach has created a really nice icon set for Horde based on the FamFamFam silk icons, and a Tango icon set has been uploaded to our ticket system.','2007-03-21 10:39:26','','','2008-02-25 21:42:48','1ffac117115d4e1069689e09afed5ed8'),(15,1,'Vortrag bei der LUG Ravensberg','http://janschneider.de/news/35/305','http://janschneider.de/news/35/305','[To the English readers: this is about a (German) talk at a local linux user group.]\n\nAm 22. M&#228;rz werde ich in Bielefeld einen Vortrag &#252;ber Horde bei der Linux Usergroup Ravensberg halten.','2007-03-20 09:15:29','','','2008-02-25 21:42:48','4f5bf4fb26b54479d65982b626e1a127'),(16,1,'Preparations for Horde 3.2 release series started','http://janschneider.de/news/35/304','http://janschneider.de/news/35/304','The release of 13 Horde applications during the last few days was the starting signal for the preparations of the Horde 3.2 release cycle. This series will not only deliver exciting new features for the stable applications, but turn some applications that are still in development into a first stable version, e.g. DIMP, Wicked or Whups.','2007-03-19 16:07:38','','','2008-02-25 21:42:48','b668da8be8b3db90dc9d1f9c82397d2f'),(18,2,'Horde/Yaml 1.0.1 released with PHP object support','http://hagenbu.ch/blog/64','http://hagenbu.ch/blog/64','The latest Horde/Yaml package supports the same !php/object constructs that the PECL syck package does.','2008-02-16 20:56:44','','','2008-02-25 21:42:48','57e3ac513880aee421a5782d2a66efb8'),(19,2,'Horde/Routes gets a home on the web','http://hagenbu.ch/blog/62','http://hagenbu.ch/blog/62','Horde has a great request routing library, and now Horde/Routes has a great website, too.','2007-11-02 22:42:20','','','2008-02-25 21:42:48','4e60ca66d062fdca3556160d62cf0439'),(20,2,'New Features in Horde 3.2','http://hagenbu.ch/blog/58','http://hagenbu.ch/blog/58','Focusing on a few of the new features in Horde 3.2','2007-08-17 22:41:40','','','2008-02-25 21:42:48','c7367a3fc16e43fdbabe792123f7a89b'),(21,2,'Horde 3.2 alpha releases!','http://hagenbu.ch/blog/56','http://hagenbu.ch/blog/56','Current status on the Horde 3.2 releases','2007-08-03 17:34:19','','','2008-02-25 21:42:48','92bba890cbc676ac129ebb3ff047f12a'),(22,2,'ORM with Horde_Rdo','http://hagenbu.ch/blog/55','http://hagenbu.ch/blog/55','An intro to ORM with Horde\'s Rdo data mapping library.','2007-06-12 20:51:00','','','2008-02-25 21:42:48','a0844dd45e95b91707a5aded83885b22'),(23,2,'Horde Application Building Podcast','http://hagenbu.ch/blog/54','http://hagenbu.ch/blog/54','A Horde podcast, recorded from a Horde Framework application-building talk at Boston PHP','2007-06-05 21:00:00','','','2008-02-25 21:42:48','17d849fabaf36ddadd513e46dbd4d2aa'),(24,2,'Horde_Lens','http://hagenbu.ch/blog/48','http://hagenbu.ch/blog/48','Horde_Lens is a decorating iterator implementation that lets you look at every element of a list through the lens of a Flyweight decorator object.','2007-05-12 16:04:00','','','2008-02-25 21:42:48','94534540587e922e3ad13be66cd4bae9'),(25,2,'Plugs for Horde Groupware','http://hagenbu.ch/blog/49','http://hagenbu.ch/blog/49','Think Horde is too hard to install? Think again.','2007-04-28 01:55:00','','','2008-02-25 21:42:48','041d5630f814f4b14f774adaa51d7441'),(26,2,'NYPHPCon slides are up','http://hagenbu.ch/blog/44','http://marina.horde.org/horde/jonah/stories/view.php?channel_id=133&story_id=44','Also, I\'m not going to PHPVikinger.','2006-06-22 21:36:00','','','2008-02-25 21:42:48','793522b0d5dca7689e74bcaa7f9bb3f5'),(27,2,'Horde Tutorial at NYPHPCon','http://hagenbu.ch/blog/43','http://marina.horde.org/horde/jonah/stories/view.php?channel_id=133&story_id=43','Mashup web 2.0 mashup web 2.0 mashup web 2.mmppphhhhh!','2006-05-28 16:54:00','','','2008-02-25 21:42:48','ce2dfca573869aed82c3fc240bcdb495'),(29,3,'Horde/Yaml 1.0 Released','http://mikenaberezny.com/2008/01/08/hordeyaml-10-released/','http://mikenaberezny.com/archives/87','','2008-02-19 21:42:49','','<p><a href=\"http://pear.horde.org/index.php?package=yaml\">Horde/Yaml</a> is a PHP 5 library for easily working with <a href=\"http://yaml.org/\">YAML</a> data.  This is the package&#8217;s first stable release.</p>\n<p><a href=\"http://chuck.hagenbu.ch/\">Chuck Hagenbuch</a> started the library as an adaptation of <a href=\"http://spyc.sourceforge.net/\">Spyc</a> around six months ago.  Since then, he and I have been quietly using and improving it.  Along the way, we fixed many issues, added support for <a href=\"http://pecl.php.net/package/syck\">pecl/syck</a>, and wrote a test suite with PHPUnit.</p>\n<p>There are a couple of other libraries also derived from Spyc, notably the <code>sfYaml</code> class from the <a href=\"http://www.symfony-project.org/\">Symfony</a> framework.  Since these efforts also found and corrected issues, we incorporated as many of these fixes as we could find and added them to the test suite as we went along.</p>\n<p>At <a href=\"http://maintainable.com\">Maintainable Software</a>, we frequently use YAML files for configuring our custom applications because our clients tend to like the format more than the alternatives.  We&#8217;ve been using Horde/Yaml successfully for quite some time so we think it should generally work well for you also.</p>\n<p>There&#8217;s a nice tutorial on <a href=\"http://railsforphp.com/2008/01/08/php-meet-yaml/\">working with YAML in PHP 5</a> over on the new <a href=\"http://railsforphp.com\">Rails for PHP Developers</a> website.  It includes everything you need to get started with Horde/Yaml.</p>\n','2008-02-25 21:42:49','10168ad80892ea3bbcc08520bcd98460'),(30,3,'New in Horde: Routes','http://mikenaberezny.com/2007/09/15/new-in-horde-routes/','http://mikenaberezny.com/archives/80','','2008-02-19 21:42:49','','<p>I&#8217;m pleased to announce the first release of <a href=\"http://pear.horde.org/index.php?package=Horde_Routes\">Horde/Routes</a>, a new URL mapping system for PHP 5.  This package provides classes for mapping URLs into the controllers and actions of an MVC system, inspired by Ruby on Rails. </p>\n<p>There are already quite a few existing libraries that do this sort of thing for PHP.  Horde/Routes is a compelling alternative.  </p>\n<p>At <a href=\"http://maintainable.com\">Maintainable</a>, we examined most of these PHP solutions and found them all inadequate for various reasons, particularly because we wanted RESTful routing, named routes, sophisticated matching, PHP 5 E_STRICT, and extensive test coverage.  </p>\n<p>Since we do quite a bit of Ruby and Python programming, we surveyed the options in those languages and decided to do a full port of the Python library, <a href=\"http://routes.groovie.org\">Routes</a>.</p>\n<p>Horde/Routes provides these features and more:</p>\n<ul>\n<li>Supports route recognition and generation</li>\n<li>Sophisticated matching conditions like subdomains</li>\n<li>Named routes and RESTful route generation</li>\n<li>PEAR-style naming and coding standards</li>\n<li>PHP 5 E_STRICT compliant, web framework agnostic</li>\n<li>A comprehensive unit test suite</li>\n</ul>\n<p>Maintainable decided to contribute the code to Horde&#8217;s <a href=\"http://wiki.horde.org/RampageFramework\">Rampage</a> project because <a href=\"http://www.horde.org\">Horde</a> is one of PHP&#8217;s oldest and most successful projects.  We&#8217;re using and contributing to other Horde libraries and we think Rampage is worth your attention.</p>\n<p>The Python version has been around for some time and is very popular with different Python web frameworks.  We&#8217;re happy to be part of that ecosystem now and our full port has already resulted in patches being committed back to the Python version.</p>\n<p>At Maintainable, we&#8217;ve already used Horde_Routes on several applications.  While Horde/Routes is relatively new, it is very feature-rich and well-tested.</p>\n<p>Currently, Horde/Routes is a beta release.  Over the coming weeks, we&#8217;ll be making some minor changes to the API and adding more <a href=\"http://cvs.horde.org/co.php?r=1.1&#038;f=framework%2FRoutes%2Fdocs%2Fmanual.txt\">documentation</a>, and then it will quickly move to stable.</p>\n<p><b>Update</b>: <i>The project now has its own <a href=\"http://dev.horde.org/routes/\">pages</a> on the Horde website and was featured on <a href=\"http://chuck.hagenbu.ch/blog/62\">Chuck Hagenbuch&#8217;s blog</a>.</i></p>\n','2008-02-25 21:42:49','3cce684da4477be8c1c54010bd013df8'),(32,4,'Lighttpd configuration specific to Horde','http://theupstairsroom.com/61','http://theupstairsroom.com?story=61','Some example entries for lighttpd.conf file for duplicating various .htaccess rules in various Horde applications','2008-02-03 21:24:00','','','2008-03-29 16:00:12','f2b58275002a6277b03c204af0dbe5bd'),(33,4,'Ansel gets RSS support','http://theupstairsroom.com/58','http://rubinskyfamily.com/mike/58/','Ansel, the Horde Project\'s photo application gets support for RSS feeds.','2007-10-05 19:21:00','','','2008-03-29 16:00:12','ab9b22ea4675eec2c72550076b25b0db'),(34,4,'Aeros, the aviation based Horde theme has been updated','http://theupstairsroom.com/50','http://theupstairsroom.com/news/view.php?feed=124&story=50','I posted a new tarball for my aviation inspired Horde theme, Aeros.  It\'s a small update that includes a few tweaks and some CSS cleanup.','2007-06-21 14:27:00','','','2008-03-29 16:00:12','be53eba64112bcc979b045b3ef9555b5'),(35,4,'Some new work on Ansel','http://theupstairsroom.com/47','http://rubinskyfamily.com/news/138/47/','I\'ve been scratching some coding itches again with the Horde Project, adding some new features to Ansel, the image gallery application.','2007-05-09 17:28:00','','','2008-03-29 16:00:12','fa923b5fae42c71c6b34cd1d33e1ec73'),(36,4,'phpSysInfo Block updated','http://theupstairsroom.com/16','http://theupstairsroom.com/news/view.php?feed=124&story=16','Some minor updates and bugfixes for the phpSysInfo block have been released...','2006-07-30 20:18:00','','','2008-03-29 16:00:12','2a00a2d1858e255a43312a4772bc3cc9'),(37,4,'New Horde Block - phpSysInfo','http://theupstairsroom.com/7','http://theupstairsroom.com/news.php?channel_id=124&story_id=7','Displays stats from machines that are running phpSysInfo on the Horde portal page.','2006-03-16 20:59:00','','','2008-03-29 16:00:12','1f6f974d04a43425367558704b01f027'),(43,2,'Planet Horde Launches','http://hagenbu.ch/blog/65','http://hagenbu.ch/blog/65','We\'ve just launched Planet Horde: http://planet.horde.org/. It\'s more of a small moon right now, but it\'s the place to be for Horde news and articles.','2008-02-27 03:39:38','','','2008-02-27 04:16:13','51086e0c8176a5b1324ac891e19d08a8'),(45,5,'Horde: Synching with HEAD','http://log.onthebrink.de/2008/02/horde-synching-with-head.html','tag:blogger.com,1999:blog-998418780028044861.post-3593761677129855906','','2008-02-27 16:48:37','','<p>\nFeels good to be finally back working on Horde. Last week saw the generation of Kolab patches for Horde-3.2-RC2 and this week I finally synchronized my work environment with Horde CVS. The first Kolab commit to Horde CVS went in yesterday. It felt like the last one was ages ago.\n</p>\n<p>\nAnyhow there are more commits ahead. Now that most parts of Horde work with Kolab the time for the second round of coding is approaching fast: restructuring and optimization. There is still a lot that needs to be done and I\'m desperately waiting for Horde 4 to finally restructure the whole Kolab module and get it on a hopefully sane path for the future.\n</p>','2008-02-27 16:48:37','8b1cbe6b9bc952260d3681ee5f26e5bb'),(46,5,'K2G: Kolab2/Gentoo getting attention again','http://log.onthebrink.de/2007/12/finally-kolab2gentoo-project-gets-some.html','tag:blogger.com,1999:blog-998418780028044861.post-818745145701986043','','2008-02-27 16:48:37','','Finally the <a href=\"http://www.gentoo.org/proj/en/kolab/\">Kolab2Gentoo</a> project gets some attention again. I started fixing some older bugs but the main part will be to prepare for 2.2 now.\n\nI still hate the way the whole project is structured but there are too many places where massive improvements are needed. So I guess I have to be content with small progress.\n\nThe stuff that is currently on my mind concerning Kolab2/Gentoo-2.2:\n\n<ul>\n<li>Update to Horde-3.2</li>\n<li>Making the patched c-client and php packages recommended instead of required</li>\n<li>Switching to a specific cyrus-imapd-kolab package</li>\n<li>Template packages</li>\n</ul>\n\nAnd then there is the big, bad problem of the Kolab configuration concept that simply fails for Gentoo in its current form. The solution to that one will take even longer.','2008-02-27 16:48:37','94fe41b14e894979c8d96411e60bcdb0'),(47,2,'Creating a Site Specific Browser for Horde','http://hagenbu.ch/blog/66','http://hagenbu.ch/blog/66','Fluid lets you create a completely encapsulated, WebKit-based browser for your web application. Here\'s a guide to making one for Horde.','2008-03-03 04:16:08','','','2008-03-03 05:00:18','0da4d9d5315f6a9ffc42531022ae84fa'),(48,4,'Update on Ansel development','http://theupstairsroom.com/63','http://theupstairsroom.com?story=63','With Horde 3.2 quickly approaching final release status, I\'ve been working on getting Ansel ready for an upcoming release. Many new features and performance improvements are on the way.','2008-03-05 00:41:01','','','2008-03-29 16:00:12','c00e4fc2e57aac033969f90894c95f4b'),(49,1,'Nice helper to create RTL CSS files','http://janschneider.de/news/35/319','http://janschneider.de/news/35/319','Via Ajaxian: CSSJanus is a CSS parser utility designed to aid the conversion of a website\'s layout from left-to-right (LTR) to right-to-left (RTL).','2008-03-05 17:28:00','','','2008-03-15 17:00:14','ac6d5e0ece6a923420e0054668d36969'),(50,2,'March Horde Board Meeting Summary','http://hagenbu.ch/blog/67','http://hagenbu.ch/blog/67','The second Horde advisory board meeting discussed Horde 3.2, Google Summer of Code, and Planet Horde','2008-03-08 02:51:29','','','2008-03-08 03:00:11','69dd115c22761eb892f3b950edf04899'),(51,5,'Sync my Kolab','http://log.onthebrink.de/2008/03/sync-my-kolab.html','tag:blogger.com,1999:blog-998418780028044861.post-2300864698879546636','','2008-03-12 21:00:14','','<a onblur=\"try {parent.deselectBloggerImageGracefully();} catch(e) {}\" href=\"http://farm3.static.flickr.com/2026/2319768962_2190d14eb2_m_d.jpg\"><img style=\"float:right; margin:0 0 10px 10px;cursor:pointer; cursor:hand;\" src=\"http://farm3.static.flickr.com/2026/2319768962_2190d14eb2_m_d.jpg\" border=\"0\" alt=\"\" /></a>\n<p>\n<a href=\"http://en.wikipedia.org/wiki/SyncML\">SyncML</a> support for the <a href=\"http://www.kolab.org\">Kolab server</a> <a href=\"http://article.gmane.org/gmane.comp.kde.kolab.user/1660/match=syncml\">has been requested</a> for several years now. Supporting it via the modules available within Horde always seemed to be one the of easiest ways to get mobile clients to synchronize with the server. Since the newest Kolab server release candidates now provide Horde, how far is SyncML support away?\n</p>\n<p>\nNot far at all... <a href=\"http://www.univention.de/\">Univention</a> contracted <a href=\"http://www.pardus.de\">p@rdus</a> via the <a href=\"http://www.kolab-konsortium.de/en/index.html\">Kolab Konsortium</a> to implement SyncML support within the Kolab server.\n</p>\n<p>\nInitially a version that would require an additional MySQL database was planned but p@rdus invested some additional time into generating purely IMAP based drivers so that SyncML support will also be available within the next Kolab release (the Kolab server does not use MySQL at all by default).\n</p>\n<p>\nToday I was able to sync the Blackberry provided by the customer for the first time. Contacts, events, tasks all survived my minimal testing. Of course the same procedure failed once I gave the customer access to the test server...\n</p>\n<p>\nSo right now I\'m entering the debugging phase and I\'m starting to prepare some scripts so that people eager to try the SyncML support can install an experimental Horde version on an external web server.\n</p>\n<h4>Update:</h4>\n<p>\nA <a href=\"http://kolab.org/cgi-bin/viewcvs-kolab.cgi/server/horde/external-horde-cvs.sh\">script</a> for installing horde from CVS is now available. It also installs all the required Kolab patches for SyncML support.\n</p>\n<p>\nYou can fetch and run it like this:\n<pre>\nwget http://kolab.org/cgi-bin/viewcvs-kolab.cgi/*checkout*/server/horde/external-horde-cvs.sh\nchmod u+x external-horde-cvs.sh\n./external-horde-cvs.sh\n</pre>\n</p>','2008-03-13 08:00:15','d7a46ef783b154fcf305796488831209'),(52,2,'Horde 3.2: Serving multiple subdomains with one installation','http://hagenbu.ch/blog/68','http://hagenbu.ch/blog/68','Horde 3.2 includes improved support for spreading Horde apps across multiple subdomains. Want to know how to set up a single Horde install to serve, for example, bugs.horde.org, wiki.horde.org, cvs.horde.org, and dev.horde.org?','2008-03-19 03:35:42','','','2008-03-19 04:00:22','1b978091a8efba37d2ff2ece04b16e07'),(53,4,'Using the Horde API to Power External Sites or Applications - Part 1','http://theupstairsroom.com/65','http://theupstairsroom.com?story=65','Horde and all of it\'s applications have a powerful API through which a developer can obtain Horde content.  In this first part of a series, we\'ll look at the basics of what is required to interact with Horde via the API.','2008-03-29 15:12:00','','','2008-03-29 16:00:12','a5ac7bade123afc291b118e530487a37'),(54,2,'Auditing Horde applications with taint mode','http://hagenbu.ch/blog/69','http://hagenbu.ch/blog/69','Using Wietse Venema\'s taint mode modification to PHP to audit Horde','2008-04-04 20:58:39','','','2008-04-04 21:00:14','94248a828ee7fa67805baca26245d41e'),(55,5,'Another round of Horde bugs...','http://log.onthebrink.de/2008/04/another-round-of-horde-bugs.html','tag:blogger.com,1999:blog-998418780028044861.post-2482205407364385305','','2008-04-24 15:00:39','','I\'m back to Horde bug fixes and while their CVS server vanished in some kind of limbo I took the time to create a <a href=\"http://wiki.horde.org/Project/Kolab\">Horde/Kolab</a> project page. Maybe it is a useful overview to the people interested in Horde. I definitely have to update the <a href=\"http://wiki.kolab.org/index.php/Horde_development\">Kolab wiki</a>, too. But that might still take a while.','2008-04-24 15:00:39','d261c6b2137d94725520255f71386ef1'),(56,5,'The OpenSourceSchool opens its doors','http://log.onthebrink.de/2008/04/opensourceschool-opens-its-doors.html','tag:blogger.com,1999:blog-998418780028044861.post-1758429239832563689','','2008-04-25 09:00:25','','<a onblur=\"try {parent.deselectBloggerImageGracefully();} catch(e) {}\" href=\"http://www.opensourceschool.de/\"><img style=\"float:right; margin:0 0 10px 10px;cursor:pointer; cursor:hand;width: 79px;\" src=\"http://www.opensourceschool.de/fileadmin/images/logo.gif\" border=\"0\" alt=\"\" /></a>\n<p>\nMy <a href=\"http://www.opensourcepress.de\">publisher</a> started with his next endeavor in bringing knowledge to the masses: The <a href=\"http://www.opensourceschool.de\">OpenSourceSchool</a>. This time it is about spoken words - or courses - rather than written pages bound as books. Many <a href=\"http://www.opensourcepress.de\">OpenSourcePress</a> authors are offering seminars there.\n</p>\n<p>\nI would definitely have liked to offer a course about <a href=\"http://www.gentoo.org\">Gentoo</a> there. But I had to agree with them that this would probably not raise enough interest from paying customers. Or am I wrong about that?\n</p>\n<p>\nBut of course there was room for the second topic dear to my heart: <a href=\"http://www.gentoo.org/proj/en/kolab/\">Kolab</a>. <a href=\"http://www.opensourceschool.de/index.php?id=15&tx_ttproducts_pi1[backPID]=13&tx_ttproducts_pi1[product]=33&cHash=0e8d3864a9\">The course</a> will take five days and touch all major topics of the Kolab Server. Central components such as postfix, openldap, cyrus imap will provide the core components but I\'ll certainly also include a chapter about getting <a href=\"http://www.horde.org\">the Horde web client</a> successfully installed. So we will hopefully have a new batch of Kolab experts in October.\n</p>\n<p>\nAnd hopefully the preparations for the course will also help in laying the groundwork for a book about Kolab. This is the only book I still want to write after going through the pain of writing <a href=\"http://www.amazon.de/gp/product/3937514341?ie=UTF8&tag=aufkant-21&linkCode=as2&camp=1638&creative=6742&creativeASIN=3937514341\">the Gentoo book</a>.\n</p>','2008-04-25 10:00:39','7d941c49ba3832a392f885ea09e901cf'),(57,2,'Preventing Email Abuse through IMP','http://hagenbu.ch/blog/70','http://hagenbu.ch/blog/70','Some IMP installations have been targeted by brute-force or phishing attacks; compromised accounts are then used to send spam. Horde 3.2 and IMP 4.2 have some new features for limiting the damage of a compromised account or a rogue user.','2008-04-30 03:05:17','','','2008-04-30 04:00:17','39aec04ae0868557871d2499734dc41b'),(58,2,'May Horde Board Meeting Summary','http://hagenbu.ch/blog/71','http://hagenbu.ch/blog/71','Discussed: Horde 3.2 releases (this month), marketing material, showstoppers, and the new www.horde.org project.','2008-05-07 03:42:30','','','2008-05-07 04:00:33','2ae3e29192a1d1dacf6333eed74ebeb7'),(59,4,'Using the Horde API to Power External Sites or Applications - Part 2','http://theupstairsroom.com/66','http://theupstairsroom.com/66','In this second part of the series, we will look at using Horde\'s RPC server to get information from a remote Horde server via Horde\'s RPC interface.','2008-05-07 18:26:58','','','2008-05-07 19:00:22','43b3f6c56496b3c249e6a254a9e54486'),(60,4,'Using the Horde API to Power External Sites or Applications - Part 3','http://theupstairsroom.com/67','http://theupstairsroom.com/67','In this installment, we\'ll take a look at a real world example of using Horde to power an external website by building a custom photo gallery with Ansel.','2008-05-08 04:21:44','','','2008-05-08 05:00:33','ef109d9ee2d2b5901fdeca7222cfed69'),(61,2,'Birth Announcement','http://hagenbu.ch/blog/72','http://hagenbu.ch/blog/72','I\'m a dad! Some details and a few thumbnails after the jump.','2008-05-12 21:15:03','','','2008-05-12 22:00:28','c0b1fd939aeca7ddafd933f7b9459578');
/*!40000 ALTER TABLE `entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `feeds`
--

DROP TABLE IF EXISTS `feeds`;
CREATE TABLE `feeds` (
  `ID` int(11) NOT NULL auto_increment,
  `blogsID` int(11) NOT NULL default '0',
  `link` varchar(255) NOT NULL default '',
  `changed` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `cats` varchar(255) NOT NULL default '',
  `section` varchar(50) NOT NULL default 'default',
  PRIMARY KEY  (`ID`),
  UNIQUE KEY `rssURL` (`link`),
  KEY `blogID` (`blogsID`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `feeds`
--

LOCK TABLES `feeds` WRITE;
/*!40000 ALTER TABLE `feeds` DISABLE KEYS */;
INSERT INTO `feeds` VALUES (1,2,'http://janschneider.de/horde/jonah/delivery/rss.php?channel_id=35','2008-02-27 04:19:11','','default'),(2,17,'http://technest.org/horde/jonah/delivery/rss.php?channel_id=133&tag_id=4','2008-02-27 04:19:24','','default'),(3,28,'http://mikenaberezny.com/wp-atom.php?tag=horde','2008-02-25 21:42:49','','default'),(4,31,'http://portal.theupstairsroom.com/horde/jonah/delivery/rss.php?channel_id=124&tag_id=10','2008-02-27 04:19:37','','default'),(5,45,'http://log.onthebrink.de/feeds/posts/default/-/horde','2008-02-27 16:47:53','','default');
/*!40000 ALTER TABLE `feeds` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `planet_seq`
--

DROP TABLE IF EXISTS `planet_seq`;
CREATE TABLE `planet_seq` (
  `sequence` int(11) NOT NULL auto_increment,
  PRIMARY KEY  (`sequence`)
) ENGINE=MyISAM AUTO_INCREMENT=62 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `planet_seq`
--

LOCK TABLES `planet_seq` WRITE;
/*!40000 ALTER TABLE `planet_seq` DISABLE KEYS */;
INSERT INTO `planet_seq` VALUES (61);
/*!40000 ALTER TABLE `planet_seq` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2008-05-13 19:18:38
