<?php
namespace Horde\Form\V3;
use Horde_Form_Translation;

class AssignType extends BaseType
{
    public $_leftValues;
    public $_rightValues;
    public $_leftHeader;
    public $_rightHeader;
    public $_size;
    public $_width;

    /**
     * Initialize an assignment field
     *
     * function init($leftValues, $rightValues, $leftHeader = '',
     *     $rightHeader = '', $size = 8, $width = '200px')
     */
    public function init(...$params)
    {
        $this->_leftValues = $params[0];
        $this->_rightValues = $params[1];
        $this->_leftHeader = $params[2] ?? '';
        $this->_rightHeader = $params[3] ?? '';
        $this->_size = $params[4] ?? 8;
        $this->_width = $params[5] ?? '200px';
    }

    public function isValid($var, Horde_Variables|array $vars, $value): bool
    {
        return true;
    }

    /**
     *     function getValues($side)
     */
    public function getValues(...$params)
    {
        return empty($params[0]) ? $this->_rightValues : $this->_leftValues;
    }

    public function setValues($side, $values)
    {
        if ($side) {
            $this->_rightValues = $values;
        } else {
            $this->_leftValues = $values;
        }
    }

    public function getHeader($side)
    {
        return $side ? $this->_rightHeader : $this->_leftHeader;
    }

    public function getSize()
    {
        return $this->_size;
    }

    public function getWidth()
    {
        return $this->_width;
    }

    public function getOptions($side, $formname, $varname)
    {
        $html = '';
        $headers = false;
        if ($side) {
            $values = $this->_rightValues;
            if (!empty($this->_rightHeader)) {
                $values = ['' => $this->_rightHeader] + $values;
                $headers = true;
            }
        } else {
            $values = $this->_leftValues;
            if (!empty($this->_leftHeader)) {
                $values = ['' => $this->_leftHeader] + $values;
                $headers = true;
            }
        }

        foreach ($values as $key => $val) {
            $html .= '<option value="' . htmlspecialchars($key) . '"';
            if ($headers) {
                $headers = false;
            } else {
                $html .= ' ondblclick="Horde_Form_Assign.move(\'' . $formname . '\', \'' . $varname . '\', ' . (int) $side . ');"';
            }
            $html .= '>' . htmlspecialchars($val) . '</option>';
        }

        return $html;
    }

    public function getInfo($vars, $var)
    {
        $info = [];
        $value = $vars->get($var->getVarName() . '__values');
        if (strpos($value, "\t\t") === false) {
            $left = $value;
            $right = '';
        } else {
            [$left, $right] = explode("\t\t", $value);
        }
        if (empty($left)) {
            $info['left'] = [];
        } else {
            $info['left'] = explode("\t", $left);
        }
        if (empty($right)) {
            $info['right'] = [];
        } else {
            $info['right'] = explode("\t", $right);
        }
        return $info;
    }

    /**
     * Return info about field type.
     */
    public function about()
    {
        return [
            'name' => Horde_Form_Translation::t("Assignment columns"),
            'params' => [
                'leftValues' => [
                    'label' => Horde_Form_Translation::t("Left values"),
                    'type'  => 'stringarray'
                ],
                'rightValues' => [
                    'label' => Horde_Form_Translation::t("Right values"),
                    'type'  => 'stringarray'
                ],
                'leftHeader' => [
                    'label' => Horde_Form_Translation::t("Left header"),
                    'type'  => 'text'
                ],
                'rightHeader' => [
                    'label' => Horde_Form_Translation::t("Right header"),
                    'type'  => 'text'
                ],
                'size' => [
                    'label' => Horde_Form_Translation::t("Size"),
                    'type'  => 'int'
                ],
                'width' => [
                    'label' => Horde_Form_Translation::t("Width in CSS units"),
                    'type'  => 'text'
                ]
            ]
        ];
    }

}
