# Horde/Form Library

AI autogenerated may 17th 2025

## Overview
Horde/Form is a powerful and flexible form handling library that provides a comprehensive set of tools for creating, validating, and processing web forms in PHP applications. It's part of the Horde Application Framework and offers a robust solution for form management with extensive field types and validation capabilities.

## UPGRADING FROM FORMS v2

### Minimum

Forms v3 lib/ folder contains a straight conversion of Forms v2 with the following BC breaking changes:
- Most parameters have been changed to NOT use references for primitives. I.e. derived forms and types need to drop the & from parameter signatures
- $type->getInfo($vars, &$info) calls now must be $info = $type->getInfo($vars, $info); 
- $bValid = $type->isValid($var, $vars, $value, $message); no longer updates the $message parameter. You need to call $type->getMessage() after $type->isValid if you want to retrieve a potentially set message

This code base is only for easily upgrading existing libraries and apps to Horde 6. It will be deprecated in the next minor release v3.1 and removed in the next major release V4.

### Namespaced

A version with more BC breaking changes is introduced in the src/V3 folder

- Class names follow strict PSR-4 scheme, i.e. Horde_Form_Type_text -> Horde\Form\V3\TextType
- Signatures based on interfaces, deriving from base class is optional
- Proper PER-CS styled code base including types, dropping underscores for properties etc
- This version will be deprecated in V4 and dropped in V5

### V4

- A more involved redesign of Forms based on PHP 8.4 features such as property hooks


## Features

### Form Field Types
The library supports a wide variety of form field types including:

- Basic Input Types:
  - Text fields
  - Password fields
  - Number fields
  - Email fields
  - Phone numbers
  - IP addresses (IPv4 and IPv6)
  - Long text areas
  - File uploads
  - Image uploads

- Selection Types:
  - Dropdown menus (enum)
  - Radio buttons
  - Checkboxes
  - Multi-select lists
  - Matrix inputs
  - Category selectors

- Date and Time:
  - Date pickers
  - Time selectors
  - DateTime combinations
  - Month/Year selectors

- Special Types:
  - Color pickers
  - Sound selectors
  - Credit card validators
  - CAPTCHA support
  - PGP/SMIME input
  - Address fields
  - Country selectors

### Key Features

1. **Validation System**
   - Built-in validation for all field types
   - Custom validation support
   - File upload validation
   - Image processing capabilities

2. **Security**
   - CSRF protection
   - File upload security
   - Input sanitization
   - Password confirmation support

3. **Flexibility**
   - Custom field type creation
   - Extensible validation rules
   - Configurable field properties
   - Support for multiple languages

4. **Integration**
   - Seamless integration with Horde Framework
   - Support for various storage backends
   - Database lookup capabilities
   - File system integration

## Usage

```php
// Example of creating a form
$form = new Horde_Form($vars);
$form->addVariable('Username', 'username', 'text', true);
$form->addVariable('Email', 'email', 'email', true);
$form->addVariable('Password', 'password', 'password', true);

// Validate form
if ($form->validate($vars)) {
    // Process form data
}
```

## Requirements

- PHP 7.0 or higher
- Horde Framework dependencies
- Required PHP extensions (varies by field type)

## Installation

```bash
composer require horde/form
```

## Documentation

For detailed documentation, please refer to the Horde documentation at:
https://www.horde.org/libraries/Horde_Form

## Contributing

Contributions are welcome! Please feel free to submit a Pull Request.

## License

See the LICENSE file for details.

## Support

For support, please use the Horde mailing lists or issue tracker:
- Mailing List: https://www.horde.org/mail/
- Issue Tracker: https://bugs.horde.org/
