<?php
/**
 * Copyright 2002-2017 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file LICENSE for license information (LGPL). If you
 * did not receive this file, see http://www.horde.org/licenses/lgpl21.
 *
 * @author   Chuck Hagenbuch <chuck@horde.org>
 * @category Horde
 * @license  http://www.horde.org/licenses/lgpl21 LGPL
 * @package  Form
 */

/**
 * Horde_Form_Action_updatefield is a Horde_Form_Action that updates
 * the value of one Horde_Form variable as the variable the action is
 * attached to is updated.
 *
 * @author    Chuck Hagenbuch <chuck@horde.org>
 * @category  Horde
 * @copyright 2002-2017 Horde LLC
 * @license   http://www.horde.org/licenses/lgpl21 LGPL
 * @package   Form
 */
class Horde_Form_Action_updatefield extends Horde_Form_Action
{
    public $_trigger = ['onchange', 'onload', 'onkeyup'];

    public function getActionScript($form, $renderer, $varname)
    {
        return 'updateField' . $this->id() . '();';
    }

    public function setValues($vars, $sourceVal, $index = null, $arrayVal = false) {}

    public function printJavaScript()
    {
        $pieces = explode('%s', $this->_params['format']);
        $fields = $this->_params['fields'] ?? [];
        $val_first = (substr($this->_params['format'], 0, 2) == '%s');
        if ($val_first) {
            array_shift($pieces);
        }
        if (substr($this->_params['format'], -2) == '%s') {
            array_pop($pieces);
        }

        $args = [];
        if ($val_first) {
            $args[] = "document.getElementById('" . array_shift($fields) . "').value";
        }
        while (count($pieces)) {
            $args[] = "'" . array_shift($pieces) . "'";
            $args[] = "document.getElementById('" . array_shift($fields) . "').value";
        }
        Horde::startBuffer();
        ?>
// Updater for <?php echo $this->getTarget() ?>.
function updateField<?php echo $this->id() ?>()
{
    var target = document.getElementById('<?php echo $this->getTarget() ?>');
    if (target) {
        target.value = (<?php echo implode(' + ', str_replace("\n", "\\n", $args)) ?>).replace(/(^ +| +$)/, '').replace(/ +/g, ' ');
    }
}<?php
                $GLOBALS['injector']->getInstance('Horde_PageOutput')
                    ->addInlineScript(Horde::endBuffer());
    }

}
