# Horde/Form Library

AI autogenerated may 17th 2025

## Overview
Horde/Form is a powerful and flexible form handling library that provides a comprehensive set of tools for creating, validating, and processing web forms in PHP applications. It's part of the Horde Application Framework and offers a robust solution for form management with extensive field types and validation capabilities.

## Features

### Form Field Types
The library supports a wide variety of form field types including:

- Basic Input Types:
  - Text fields
  - Password fields
  - Number fields
  - Email fields
  - Phone numbers
  - IP addresses (IPv4 and IPv6)
  - Long text areas
  - File uploads
  - Image uploads

- Selection Types:
  - Dropdown menus (enum)
  - Radio buttons
  - Checkboxes
  - Multi-select lists
  - Matrix inputs
  - Category selectors

- Date and Time:
  - Date pickers
  - Time selectors
  - DateTime combinations
  - Month/Year selectors

- Special Types:
  - Color pickers
  - Sound selectors
  - Credit card validators
  - CAPTCHA support
  - PGP/SMIME input
  - Address fields
  - Country selectors

### Key Features

1. **Validation System**
   - Built-in validation for all field types
   - Custom validation support
   - File upload validation
   - Image processing capabilities

2. **Security**
   - CSRF protection
   - File upload security
   - Input sanitization
   - Password confirmation support

3. **Flexibility**
   - Custom field type creation
   - Extensible validation rules
   - Configurable field properties
   - Support for multiple languages

4. **Integration**
   - Seamless integration with Horde Framework
   - Support for various storage backends
   - Database lookup capabilities
   - File system integration

## Usage

```php
// Example of creating a form
$form = new Horde_Form($vars);
$form->addVariable('Username', 'username', 'text', true);
$form->addVariable('Email', 'email', 'email', true);
$form->addVariable('Password', 'password', 'password', true);

// Validate form
if ($form->validate($vars)) {
    // Process form data
}
```

## Requirements

- PHP 7.0 or higher
- Horde Framework dependencies
- Required PHP extensions (varies by field type)

## Installation

```bash
composer require horde/form
```

## Documentation

For detailed documentation, please refer to the Horde documentation at:
https://www.horde.org/libraries/Horde_Form

## Contributing

Contributions are welcome! Please feel free to submit a Pull Request.

## License

See the LICENSE file for details.

## Support

For support, please use the Horde mailing lists or issue tracker:
- Mailing List: https://www.horde.org/mail/
- Issue Tracker: https://bugs.horde.org/
