<?php

/**
 * The Horde_Core_Auth_Ldap class provides Horde-specific code that
 * extends the base LDAP driver.
 *
 * Copyright 2010-2017 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file LICENSE for license information (LGPL). If you did
 * not receive this file, see http://opensource.org/licenses/lgpl-2.1.php
 *
 * @author   Michael Slusarz <slusarz@horde.org>
 * @category Horde
 * @license  http://opensource.org/licenses/lgpl-2.1.php LGPL
 * @package  Core
 */
class Horde_Core_Auth_Ldap extends Horde_Auth_Ldap
{
    /**
     * Add a set of authentication credentials.
     *
     * @param string $userId      The user ID to add.
     * @param array $credentials  The credentials to use.
     *
     * @throws Horde_Auth_Exception
     */
    public function addUser($userId, $credentials)
    {
        [$userId, $credentials] = $GLOBALS['injector']->getInstance('Horde_Core_Factory_Auth')->create()->runHook($userId, $credentials, 'preauthenticate', 'admin');

        parent::addUser($userId, $credentials);
    }

    /**
     * Update a set of authentication credentials.
     *
     * @param string $oldID       The old user ID.
     * @param string $newID       The new user ID.
     * @param array $credentials  The new credentials
     * @param string $olddn       NOT USED.
     * @param string $newdn       NOT USED.
     *
     * @throws Horde_Auth_Exception
     */
    public function updateUser(
        $oldID,
        $newID,
        $credentials,
        $olddn = null,
        $newdn = null
    ) {
        $auth = $GLOBALS['injector']->getInstance('Horde_Core_Factory_Auth')->create();

        [$oldID, $old_credentials] = $auth->runHook($oldID, $credentials, 'preauthenticate', 'admin');
        [$newID, $new_credentials] = $auth->runHook($newID, $credentials, 'preauthenticate', 'admin');
        $olddn = $old_credentials['dn'] ?? null;
        $newdn = $new_credentials['dn'] ?? null;

        parent::updateUser($oldID, $newID, $new_credentials, $olddn, $newdn);
    }

    /**
     * Delete a set of authentication credentials.
     *
     * @param string $userId  The user ID to delete.
     * @param string $dn      NOT USED.
     *
     * @throws Horde_Auth_Exception
     */
    public function removeUser($userId, $dn = null)
    {
        [$userId, $credentials] = $GLOBALS['injector']->getInstance('Horde_Core_Factory_Auth')->create()->runHook($userId, [], 'preauthenticate', 'admin');

        parent::removeUser($userId, isset($credentials['ldap']) ? $credentials['ldap']['dn'] : null);
    }

}
