// Code generated by protoc-gen-go.
// source: google.golang.org/cloud/bigtable/internal/service_proto/bigtable_service.proto
// DO NOT EDIT!

package google_bigtable_v1

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_bigtable_v11 "google.golang.org/cloud/bigtable/internal/data_proto"
import google_protobuf1 "github.com/golang/protobuf/ptypes/empty"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion3

// Client API for BigtableService service

type BigtableServiceClient interface {
	// Streams back the contents of all requested rows, optionally applying
	// the same Reader filter to each. Depending on their size, rows may be
	// broken up across multiple responses, but atomicity of each row will still
	// be preserved.
	ReadRows(ctx context.Context, in *ReadRowsRequest, opts ...grpc.CallOption) (BigtableService_ReadRowsClient, error)
	// Returns a sample of row keys in the table. The returned row keys will
	// delimit contiguous sections of the table of approximately equal size,
	// which can be used to break up the data for distributed tasks like
	// mapreduces.
	SampleRowKeys(ctx context.Context, in *SampleRowKeysRequest, opts ...grpc.CallOption) (BigtableService_SampleRowKeysClient, error)
	// Mutates a row atomically. Cells already present in the row are left
	// unchanged unless explicitly changed by 'mutation'.
	MutateRow(ctx context.Context, in *MutateRowRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
	// Mutates multiple rows in a batch. Each individual row is mutated
	// atomically as in MutateRow, but the entire batch is not executed
	// atomically.
	MutateRows(ctx context.Context, in *MutateRowsRequest, opts ...grpc.CallOption) (*MutateRowsResponse, error)
	// Mutates a row atomically based on the output of a predicate Reader filter.
	CheckAndMutateRow(ctx context.Context, in *CheckAndMutateRowRequest, opts ...grpc.CallOption) (*CheckAndMutateRowResponse, error)
	// Modifies a row atomically, reading the latest existing timestamp/value from
	// the specified columns and writing a new value at
	// max(existing timestamp, current server time) based on pre-defined
	// read/modify/write rules. Returns the new contents of all modified cells.
	ReadModifyWriteRow(ctx context.Context, in *ReadModifyWriteRowRequest, opts ...grpc.CallOption) (*google_bigtable_v11.Row, error)
}

type bigtableServiceClient struct {
	cc *grpc.ClientConn
}

func NewBigtableServiceClient(cc *grpc.ClientConn) BigtableServiceClient {
	return &bigtableServiceClient{cc}
}

func (c *bigtableServiceClient) ReadRows(ctx context.Context, in *ReadRowsRequest, opts ...grpc.CallOption) (BigtableService_ReadRowsClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_BigtableService_serviceDesc.Streams[0], c.cc, "/google.bigtable.v1.BigtableService/ReadRows", opts...)
	if err != nil {
		return nil, err
	}
	x := &bigtableServiceReadRowsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type BigtableService_ReadRowsClient interface {
	Recv() (*ReadRowsResponse, error)
	grpc.ClientStream
}

type bigtableServiceReadRowsClient struct {
	grpc.ClientStream
}

func (x *bigtableServiceReadRowsClient) Recv() (*ReadRowsResponse, error) {
	m := new(ReadRowsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *bigtableServiceClient) SampleRowKeys(ctx context.Context, in *SampleRowKeysRequest, opts ...grpc.CallOption) (BigtableService_SampleRowKeysClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_BigtableService_serviceDesc.Streams[1], c.cc, "/google.bigtable.v1.BigtableService/SampleRowKeys", opts...)
	if err != nil {
		return nil, err
	}
	x := &bigtableServiceSampleRowKeysClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type BigtableService_SampleRowKeysClient interface {
	Recv() (*SampleRowKeysResponse, error)
	grpc.ClientStream
}

type bigtableServiceSampleRowKeysClient struct {
	grpc.ClientStream
}

func (x *bigtableServiceSampleRowKeysClient) Recv() (*SampleRowKeysResponse, error) {
	m := new(SampleRowKeysResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *bigtableServiceClient) MutateRow(ctx context.Context, in *MutateRowRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.bigtable.v1.BigtableService/MutateRow", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableServiceClient) MutateRows(ctx context.Context, in *MutateRowsRequest, opts ...grpc.CallOption) (*MutateRowsResponse, error) {
	out := new(MutateRowsResponse)
	err := grpc.Invoke(ctx, "/google.bigtable.v1.BigtableService/MutateRows", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableServiceClient) CheckAndMutateRow(ctx context.Context, in *CheckAndMutateRowRequest, opts ...grpc.CallOption) (*CheckAndMutateRowResponse, error) {
	out := new(CheckAndMutateRowResponse)
	err := grpc.Invoke(ctx, "/google.bigtable.v1.BigtableService/CheckAndMutateRow", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableServiceClient) ReadModifyWriteRow(ctx context.Context, in *ReadModifyWriteRowRequest, opts ...grpc.CallOption) (*google_bigtable_v11.Row, error) {
	out := new(google_bigtable_v11.Row)
	err := grpc.Invoke(ctx, "/google.bigtable.v1.BigtableService/ReadModifyWriteRow", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for BigtableService service

type BigtableServiceServer interface {
	// Streams back the contents of all requested rows, optionally applying
	// the same Reader filter to each. Depending on their size, rows may be
	// broken up across multiple responses, but atomicity of each row will still
	// be preserved.
	ReadRows(*ReadRowsRequest, BigtableService_ReadRowsServer) error
	// Returns a sample of row keys in the table. The returned row keys will
	// delimit contiguous sections of the table of approximately equal size,
	// which can be used to break up the data for distributed tasks like
	// mapreduces.
	SampleRowKeys(*SampleRowKeysRequest, BigtableService_SampleRowKeysServer) error
	// Mutates a row atomically. Cells already present in the row are left
	// unchanged unless explicitly changed by 'mutation'.
	MutateRow(context.Context, *MutateRowRequest) (*google_protobuf1.Empty, error)
	// Mutates multiple rows in a batch. Each individual row is mutated
	// atomically as in MutateRow, but the entire batch is not executed
	// atomically.
	MutateRows(context.Context, *MutateRowsRequest) (*MutateRowsResponse, error)
	// Mutates a row atomically based on the output of a predicate Reader filter.
	CheckAndMutateRow(context.Context, *CheckAndMutateRowRequest) (*CheckAndMutateRowResponse, error)
	// Modifies a row atomically, reading the latest existing timestamp/value from
	// the specified columns and writing a new value at
	// max(existing timestamp, current server time) based on pre-defined
	// read/modify/write rules. Returns the new contents of all modified cells.
	ReadModifyWriteRow(context.Context, *ReadModifyWriteRowRequest) (*google_bigtable_v11.Row, error)
}

func RegisterBigtableServiceServer(s *grpc.Server, srv BigtableServiceServer) {
	s.RegisterService(&_BigtableService_serviceDesc, srv)
}

func _BigtableService_ReadRows_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReadRowsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BigtableServiceServer).ReadRows(m, &bigtableServiceReadRowsServer{stream})
}

type BigtableService_ReadRowsServer interface {
	Send(*ReadRowsResponse) error
	grpc.ServerStream
}

type bigtableServiceReadRowsServer struct {
	grpc.ServerStream
}

func (x *bigtableServiceReadRowsServer) Send(m *ReadRowsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _BigtableService_SampleRowKeys_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(SampleRowKeysRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BigtableServiceServer).SampleRowKeys(m, &bigtableServiceSampleRowKeysServer{stream})
}

type BigtableService_SampleRowKeysServer interface {
	Send(*SampleRowKeysResponse) error
	grpc.ServerStream
}

type bigtableServiceSampleRowKeysServer struct {
	grpc.ServerStream
}

func (x *bigtableServiceSampleRowKeysServer) Send(m *SampleRowKeysResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _BigtableService_MutateRow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateRowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableServiceServer).MutateRow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.v1.BigtableService/MutateRow",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableServiceServer).MutateRow(ctx, req.(*MutateRowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableService_MutateRows_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateRowsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableServiceServer).MutateRows(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.v1.BigtableService/MutateRows",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableServiceServer).MutateRows(ctx, req.(*MutateRowsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableService_CheckAndMutateRow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckAndMutateRowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableServiceServer).CheckAndMutateRow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.v1.BigtableService/CheckAndMutateRow",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableServiceServer).CheckAndMutateRow(ctx, req.(*CheckAndMutateRowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableService_ReadModifyWriteRow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadModifyWriteRowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableServiceServer).ReadModifyWriteRow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.v1.BigtableService/ReadModifyWriteRow",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableServiceServer).ReadModifyWriteRow(ctx, req.(*ReadModifyWriteRowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BigtableService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.bigtable.v1.BigtableService",
	HandlerType: (*BigtableServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "MutateRow",
			Handler:    _BigtableService_MutateRow_Handler,
		},
		{
			MethodName: "MutateRows",
			Handler:    _BigtableService_MutateRows_Handler,
		},
		{
			MethodName: "CheckAndMutateRow",
			Handler:    _BigtableService_CheckAndMutateRow_Handler,
		},
		{
			MethodName: "ReadModifyWriteRow",
			Handler:    _BigtableService_ReadModifyWriteRow_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ReadRows",
			Handler:       _BigtableService_ReadRows_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "SampleRowKeys",
			Handler:       _BigtableService_SampleRowKeys_Handler,
			ServerStreams: true,
		},
	},
	Metadata: fileDescriptor1,
}

func init() {
	proto.RegisterFile("google.golang.org/cloud/bigtable/internal/service_proto/bigtable_service.proto", fileDescriptor1)
}

var fileDescriptor1 = []byte{
	// 355 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xac, 0x92, 0xcd, 0x4a, 0xfb, 0x40,
	0x14, 0xc5, 0x1b, 0xf8, 0xf3, 0x47, 0x07, 0x44, 0x1c, 0xb0, 0x42, 0xdd, 0xd5, 0x0f, 0x14, 0xec,
	0xc4, 0xaf, 0x17, 0xb0, 0x22, 0x08, 0xa5, 0x52, 0xda, 0x45, 0x71, 0xa1, 0x65, 0x92, 0xdc, 0x4e,
	0x83, 0x49, 0x6e, 0x9c, 0x99, 0xb4, 0xf4, 0x0d, 0x7c, 0x42, 0x9f, 0x47, 0xd3, 0x64, 0xa2, 0x6d,
	0x63, 0xed, 0xc2, 0x65, 0xef, 0xf9, 0xdd, 0x73, 0x4e, 0xef, 0x84, 0x3c, 0x08, 0x44, 0x11, 0x00,
	0x13, 0x18, 0xf0, 0x48, 0x30, 0x94, 0xc2, 0x76, 0x03, 0x4c, 0x3c, 0xdb, 0xf1, 0x85, 0xe6, 0x4e,
	0x00, 0xb6, 0x1f, 0x69, 0x90, 0x11, 0x0f, 0x6c, 0x05, 0x72, 0xec, 0xbb, 0x30, 0x88, 0x25, 0x6a,
	0x2c, 0xf4, 0x41, 0x3e, 0x66, 0xb3, 0x31, 0xa5, 0xb9, 0x9f, 0x91, 0xd9, 0xf8, 0xa2, 0x76, 0xbf,
	0x7e, 0x86, 0xc7, 0x35, 0x5f, 0x0c, 0x48, 0x67, 0x99, 0x7b, 0xad, 0xff, 0x57, 0x6d, 0x07, 0x21,
	0x28, 0xc5, 0x05, 0xa8, 0xdc, 0x78, 0x3f, 0x33, 0xb6, 0x67, 0xbf, 0x9c, 0x64, 0x68, 0x43, 0x18,
	0xeb, 0x69, 0x26, 0x5e, 0xbe, 0xff, 0x23, 0xdb, 0xcd, 0xdc, 0xa0, 0x97, 0xed, 0xd3, 0x47, 0xb2,
	0xd1, 0x05, 0xee, 0x75, 0x71, 0xa2, 0xe8, 0x01, 0x5b, 0xfe, 0xd3, 0xcc, 0xa8, 0x5d, 0x78, 0x4d,
	0x40, 0xe9, 0xda, 0xe1, 0x6a, 0x48, 0xc5, 0x18, 0x29, 0xa8, 0x57, 0xce, 0x2d, 0x3a, 0x22, 0x5b,
	0x3d, 0x1e, 0xc6, 0x01, 0x7c, 0x2a, 0x2d, 0x98, 0x2a, 0x7a, 0x52, 0xb6, 0x3a, 0x87, 0x98, 0x90,
	0xd3, 0x35, 0xc8, 0x6f, 0x49, 0x2d, 0xb2, 0xd9, 0x4e, 0x34, 0xd7, 0xa9, 0x48, 0x4b, 0x0b, 0x16,
	0xb2, 0x49, 0xa8, 0x1a, 0xca, 0x5c, 0x8a, 0xdd, 0xa5, 0x97, 0xaa, 0x57, 0xe8, 0x13, 0x21, 0x05,
	0xad, 0xe8, 0xd1, 0x4a, 0xb7, 0xa2, 0xf0, 0xf1, 0x6f, 0x98, 0x69, 0x4b, 0x25, 0xd9, 0xb9, 0x1d,
	0x81, 0xfb, 0x72, 0x13, 0x79, 0x5f, 0x9d, 0xcf, 0xca, 0xd6, 0x97, 0x30, 0x13, 0xd6, 0x58, 0x93,
	0x2e, 0x32, 0x9f, 0x09, 0x4d, 0x5f, 0xa8, 0x8d, 0x9e, 0x3f, 0x9c, 0xf6, 0xa5, 0x9f, 0x85, 0x36,
	0x7e, 0x7a, 0xc9, 0x79, 0xce, 0xa4, 0xee, 0x95, 0xe2, 0x38, 0xa9, 0x57, 0x9a, 0xd7, 0xa4, 0xea,
	0x62, 0x58, 0xa2, 0x37, 0x77, 0x17, 0xbe, 0x37, 0xd5, 0x49, 0xcf, 0xdd, 0xb1, 0xde, 0x2c, 0xcb,
	0xf9, 0x3f, 0x3b, 0xfd, 0xd5, 0x47, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa3, 0x7b, 0xf2, 0x8a, 0xbb,
	0x03, 0x00, 0x00,
}
